/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.config;

import com.bfd.harpc.RpcException;
import com.bfd.harpc.config.IConfigCheck;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;

public class RegistryConfig
implements IConfigCheck {
    private String id;
    private String connectstr;
    private int timeout = 3000;
    private int retry = 1;
    private boolean singleton = true;
    private String namespace = "harpc";
    private String auth;
    private CuratorFramework zkClient;

    public CuratorFramework obtainZkClient() throws RpcException {
        this.check();
        if (this.singleton) {
            if (this.zkClient == null) {
                this.zkClient = this.create();
                this.zkClient.start();
            }
            return this.zkClient;
        }
        this.zkClient = this.create();
        return this.zkClient;
    }

    private CuratorFramework create() throws RpcException {
        return this.create(this.connectstr, this.timeout, this.namespace, this.retry);
    }

    private CuratorFramework create(String connectString, Integer sessionTimeout, String namespace, int retry) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        if (StringUtils.isNotEmpty((String)this.auth)) {
            builder.authorization("digest", this.auth.getBytes());
        }
        return builder.connectString(connectString).sessionTimeoutMs(sessionTimeout.intValue()).connectionTimeoutMs(sessionTimeout.intValue()).namespace(namespace).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, retry)).defaultData(null).build();
    }

    public void close() {
        if (this.zkClient != null) {
            this.zkClient.close();
        }
    }

    @Override
    public void check() throws RpcException {
        if (StringUtils.isEmpty((String)this.connectstr)) {
            throw new RpcException(5, "The params 'connectstr' cannot empty!");
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getConnectstr() {
        return this.connectstr;
    }

    public void setConnectstr(String connectstr) {
        this.connectstr = connectstr;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getRetry() {
        return this.retry;
    }

    public void setRetry(int retry) {
        this.retry = retry;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getAuth() {
        return this.auth;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }
}

