/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.bfd.harpc.RpcException;
import com.bfd.harpc.common.NetUtils;
import com.bfd.harpc.common.ServerNode;
import com.bfd.harpc.config.IConfigCheck;
import com.bfd.harpc.config.RegistryConfig;
import com.bfd.harpc.monitor.RpcMonitor;
import com.bfd.harpc.proxy.DynamicServiceHandler;
import com.bfd.harpc.registry.IRegistry;
import com.bfd.harpc.registry.ZkServerRegistry;
import com.bfd.harpc.server.IServer;
import com.bfd.harpc.server.avro.AvroServer;
import com.bfd.harpc.server.thrift.ThriftServer;
import java.lang.reflect.Constructor;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.thrift.TProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConfig
implements IConfigCheck {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String name;
    private String owner;
    private int port = 19090;
    private String protocol = "thrift";
    @JSONField(serialize=false)
    private int weight = 1;
    private String ip;
    @JSONField(serialize=false)
    private Object ref;
    private String service;
    private boolean monitor;
    private int interval = 300;
    private int maxWorkerThreads = Integer.MAX_VALUE;
    private int minWorkerThreads = 10;
    private IRegistry registry;
    private RpcMonitor rpcMonitor;
    private IServer server;

    public void export(RegistryConfig registryConfig) throws ClassNotFoundException, RpcException {
        this.check();
        ServerNode serverNode = this.genServerNode();
        ZkServerRegistry registry = null;
        if (registryConfig != null) {
            CuratorFramework zkClient = registryConfig.obtainZkClient();
            if (StringUtils.isEmpty((String)registryConfig.getAuth())) {
                throw new RpcException(5, "The params 'auth' cannot empty!");
            }
            registry = new ZkServerRegistry(zkClient, this.service, serverNode.genAddress(), registryConfig.getAuth());
        }
        RpcMonitor rpcMonitor = null;
        if (this.monitor) {
            rpcMonitor = new RpcMonitor(this.interval, registryConfig.obtainZkClient(), this.service, false);
        }
        IServer server = this.createServer(serverNode, rpcMonitor);
        server.start();
        if (server.isStarted()) {
            this.server = server;
            this.registry = registry;
            this.rpcMonitor = rpcMonitor;
            try {
                registry.register(this.genConfigJson());
                this.addShutdownHook(registry, server);
            }
            catch (Exception e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
                server.stop();
            }
        } else {
            server.stop();
        }
    }

    protected IServer createServer(ServerNode serverNode, RpcMonitor rpcMonitor) throws ClassNotFoundException {
        IServer server = null;
        if (StringUtils.equalsIgnoreCase((String)this.protocol, (String)"thrift")) {
            TProcessor processor = this.reflectProcessor(rpcMonitor, serverNode);
            server = new ThriftServer(processor, serverNode, this.maxWorkerThreads, this.minWorkerThreads, rpcMonitor);
        } else if (StringUtils.equalsIgnoreCase((String)this.protocol, (String)"avro")) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class protocolIface = this.reflectProtocolClass();
            SpecificResponder responder = new SpecificResponder(this.reflectProtocolClass(), this.getProxy(classLoader, protocolIface, this.ref, rpcMonitor, serverNode));
            server = new AvroServer((Responder)responder, serverNode, this.maxWorkerThreads, this.minWorkerThreads, rpcMonitor);
        } else {
            throw new RpcException(5, "Unsupport protocal,please check the params 'protocal'!");
        }
        return server;
    }

    protected TProcessor reflectProcessor(RpcMonitor rpcMonitor, ServerNode serverNode) {
        Class<?> serviceClass = this.getRef().getClass();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?>[] interfaces = serviceClass.getInterfaces();
        if (interfaces.length == 0) {
            throw new RpcException("Service class should implements Iface!");
        }
        TProcessor processor = null;
        for (Class<?> clazz : interfaces) {
            String cname = clazz.getSimpleName();
            if (!cname.equals("Iface")) continue;
            String pname = clazz.getEnclosingClass().getName() + "$Processor";
            try {
                Class<?> pclass = classLoader.loadClass(pname);
                Constructor<?> constructor = pclass.getConstructor(clazz);
                processor = (TProcessor)constructor.newInstance(this.getProxy(classLoader, clazz, this.getRef(), rpcMonitor, serverNode));
            }
            catch (Exception e) {
                throw new RpcException("Refact error,please check your thift gen class!", e.getCause());
            }
        }
        if (processor == null) {
            throw new RpcException("Service class should implements $Iface!");
        }
        return processor;
    }

    private Object getProxy(ClassLoader classLoader, Class<?> interfaces, Object object, RpcMonitor rpcMonitor, ServerNode serverNode) throws ClassNotFoundException {
        DynamicServiceHandler dynamicServiceHandler = new DynamicServiceHandler();
        return dynamicServiceHandler.bind(classLoader, interfaces, object, rpcMonitor, serverNode);
    }

    protected Class reflectProtocolClass() {
        Class<?> serviceClass = this.getRef().getClass();
        Class<?>[] interfaces = serviceClass.getInterfaces();
        if (interfaces.length == 0) {
            throw new RpcException("Service class should implements avro's interface!");
        }
        for (Class<?> clazz : interfaces) {
            try {
                clazz.getDeclaredField("PROTOCOL").get(null);
                return clazz;
            }
            catch (Exception e) {
            }
        }
        throw new RpcException("Service class should implements avro's interface!");
    }

    protected ServerNode genServerNode() {
        String ip = null;
        ip = StringUtils.isNotEmpty((String)this.getIp()) ? this.getIp() : NetUtils.getLocalHost();
        if (ip == null) {
            throw new RpcException("Can't find server ip!");
        }
        return new ServerNode(ip, this.getPort());
    }

    @Override
    public void check() throws RpcException {
        if (StringUtils.isEmpty((String)this.service)) {
            throw new RpcException(5, "The params 'service' cannot empty!");
        }
        if (this.interval < 60) {
            throw new RpcException(5, "The params 'interval' must >= 60!");
        }
    }

    public void destory() {
        if (this.rpcMonitor != null) {
            this.rpcMonitor.destroy();
        }
        if (this.registry != null) {
            this.registry.unregister();
        }
        if (this.server != null) {
            this.server.stop();
        }
    }

    protected String genConfigJson() {
        return JSON.toJSONString((Object)this);
    }

    protected void addShutdownHook(final IRegistry registry, final IServer server) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (ServerConfig.this.rpcMonitor != null) {
                    ServerConfig.this.rpcMonitor.destroy();
                }
                if (registry != null) {
                    registry.unregister();
                }
                if (server != null) {
                    server.stop();
                }
            }
        }));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Object getRef() {
        return this.ref;
    }

    public void setRef(Object ref) {
        this.ref = ref;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public boolean isMonitor() {
        return this.monitor;
    }

    public void setMonitor(boolean monitor) {
        this.monitor = monitor;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getMaxWorkerThreads() {
        return this.maxWorkerThreads;
    }

    public void setMaxWorkerThreads(int maxWorkerThreads) {
        this.maxWorkerThreads = maxWorkerThreads;
    }

    public int getMinWorkerThreads() {
        return this.minWorkerThreads;
    }

    public void setMinWorkerThreads(int minWorkerThreads) {
        this.minWorkerThreads = minWorkerThreads;
    }
}

