/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.config.spring;

import com.alibaba.fastjson.annotation.JSONField;
import com.bfd.harpc.RpcException;
import com.bfd.harpc.client.DefaultInvoker;
import com.bfd.harpc.common.NetUtils;
import com.bfd.harpc.common.ServerNode;
import com.bfd.harpc.config.ClientConfig;
import com.bfd.harpc.config.RegistryConfig;
import com.bfd.harpc.heartbeat.HeartBeatManager;
import com.bfd.harpc.loadbalance.LoadBalancer;
import com.bfd.harpc.loadbalance.LoadBalancerFactory;
import com.bfd.harpc.loadbalance.common.DynamicHostSet;
import com.bfd.harpc.monitor.RpcMonitor;
import com.bfd.harpc.proxy.DynamicClientHandler;
import com.bfd.harpc.registry.DefaultRegistry;
import com.bfd.harpc.registry.IRegistry;
import com.bfd.harpc.registry.ZkClientRegistry;
import java.util.Map;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ClientBean
extends ClientConfig
implements FactoryBean,
ApplicationContextAware {
    private String id;
    private ApplicationContext applicationContext;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object createProxy() throws Exception {
        Map regMap;
        this.check();
        CuratorFramework zkClient = null;
        IRegistry registry = null;
        ServerNode clientNode = new ServerNode(NetUtils.getLocalHost(), 0);
        if (this.getAddress() != null) {
            registry = new DefaultRegistry(this.getAddress());
        } else if (this.applicationContext != null && (regMap = this.applicationContext.getBeansOfType(RegistryConfig.class)) != null && regMap.size() > 0) {
            for (String key : regMap.keySet()) {
                if (regMap.get(key) == null) continue;
                try {
                    zkClient = ((RegistryConfig)regMap.get(key)).obtainZkClient();
                    registry = new ZkClientRegistry(this.getService(), zkClient, clientNode);
                    break;
                }
                catch (Exception e) {
                    throw new RpcException("Registry error!", (Throwable)e);
                }
            }
        }
        if (registry == null) {
            throw new RpcException("The param addess and registry config cannot all no exist!");
        }
        registry.register(this.genConfigJson());
        RpcMonitor rpcMonitor = null;
        if (this.isMonitor()) {
            rpcMonitor = new RpcMonitor(this.getInterval(), zkClient, this.getService(), true);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> objectClass = classLoader.loadClass(this.getIface());
        GenericKeyedObjectPool pool = this.bulidClientPool(classLoader, objectClass);
        HeartBeatManager heartBeatManager = new HeartBeatManager(registry.findAllService(), this.getHeartbeat(), this.getHeartbeatTimeout(), this.getHeartbeatTimes(), this.getHeartbeatInterval(), pool);
        heartBeatManager.startHeatbeatTimer();
        DynamicHostSet hostSet = registry.findAllService();
        LoadBalancer<ServerNode> loadBalancer = LoadBalancerFactory.createLoadBalancer(hostSet, this.getLoadbalance(), heartBeatManager);
        this.addShutdownHook(registry, rpcMonitor, heartBeatManager);
        DefaultInvoker invoker = new DefaultInvoker(clientNode, pool, loadBalancer, this.getRetry(), rpcMonitor, hostSet);
        DynamicClientHandler dynamicClientHandler = new DynamicClientHandler(invoker);
        return dynamicClientHandler.bind(classLoader, objectClass);
    }

    @JSONField(serialize=false)
    public Object getObject() throws Exception {
        return this.createProxy();
    }

    @JSONField(serialize=false)
    public Class getObjectType() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> objectClass = null;
        try {
            objectClass = classLoader.loadClass(this.getIface());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return objectClass;
    }

    public boolean isSingleton() {
        return true;
    }
}

