/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.config.spring;

import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class HarpcBeanDefinitionParser
implements BeanDefinitionParser {
    private final Class<?> beanClass;

    public HarpcBeanDefinitionParser(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        return this.parse(element, parserContext, this.beanClass);
    }

    private BeanDefinition parse(Element element, ParserContext parserContext, Class<?> clazz) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(clazz);
        Method[] methods = clazz.getMethods();
        String id = "";
        for (Method method : methods) {
            if (method.getName().length() <= 3 || !method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
            String attribute = method.getName().substring(3);
            char ch = attribute.charAt(0);
            String value = element.getAttribute(attribute = Character.toLowerCase(ch) + attribute.substring(1));
            if (!StringUtils.isNotEmpty((String)value)) continue;
            Class<?> type = method.getParameterTypes()[0];
            if (type == Boolean.TYPE) {
                beanDefinition.getPropertyValues().addPropertyValue(attribute, (Object)Boolean.valueOf(value));
                continue;
            }
            if ("ref".equals(attribute) && parserContext.getRegistry().containsBeanDefinition(value)) {
                beanDefinition.getPropertyValues().addPropertyValue(attribute, (Object)new RuntimeBeanReference(value));
                continue;
            }
            beanDefinition.getPropertyValues().addPropertyValue(attribute, (Object)value);
            if (!"id".equals(attribute)) continue;
            id = value;
        }
        parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        return beanDefinition;
    }
}

