/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.config.spring;

import com.bfd.harpc.RpcException;
import com.bfd.harpc.common.ServerNode;
import com.bfd.harpc.config.RegistryConfig;
import com.bfd.harpc.config.ServerConfig;
import com.bfd.harpc.monitor.RpcMonitor;
import com.bfd.harpc.registry.ZkServerRegistry;
import com.bfd.harpc.server.IServer;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ServerBean
extends ServerConfig
implements ApplicationContextAware,
InitializingBean {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String id;
    private ApplicationContext applicationContext;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.export();
    }

    public void export() throws ClassNotFoundException, RpcException {
        Map regMap;
        this.check();
        CuratorFramework zkClient = null;
        String auth = null;
        if (this.applicationContext != null && (regMap = this.applicationContext.getBeansOfType(RegistryConfig.class)) != null && regMap.size() > 0) {
            for (String key : regMap.keySet()) {
                if (regMap.get(key) == null) continue;
                try {
                    zkClient = ((RegistryConfig)regMap.get(key)).obtainZkClient();
                    auth = ((RegistryConfig)regMap.get(key)).getAuth();
                    if (StringUtils.isEmpty((String)auth)) {
                        throw new RpcException(5, "The params 'auth' cannot empty!");
                    }
                    break;
                }
                catch (Exception e) {
                    throw new RpcException("Registry error!", (Throwable)e);
                }
            }
        }
        ZkServerRegistry registry = null;
        ServerNode serverNode = this.genServerNode();
        if (zkClient != null) {
            registry = new ZkServerRegistry(zkClient, this.getService(), serverNode.genAddress(), auth);
        }
        RpcMonitor rpcMonitor = null;
        if (this.isMonitor()) {
            rpcMonitor = new RpcMonitor(this.getInterval(), zkClient, this.getService(), false);
        }
        IServer server = this.createServer(serverNode, rpcMonitor);
        server.start();
        if (server.isStarted()) {
            try {
                registry.register(this.genConfigJson());
                this.addShutdownHook(registry, server);
            }
            catch (Exception e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
                server.stop();
            }
        } else {
            server.stop();
        }
    }
}

