/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.heartbeat;

import com.bfd.harpc.common.ServerNode;
import com.bfd.harpc.heartbeat.HeartBeatTask;
import com.bfd.harpc.loadbalance.common.DynamicHostSet;
import com.bfd.harpc.monitor.NamedThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatManager<T> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final ScheduledExecutorService scheduled = Executors.newScheduledThreadPool(1, new NamedThreadFactory("Harpc-Heartbeat", true));
    private final DynamicHostSet dynamicHostSet;
    private ScheduledFuture<?> heatbeatTimer;
    private final int heartbeat;
    private final int heartbeatTimeout;
    private final int times;
    private final int interval;
    private final GenericKeyedObjectPool<ServerNode, T> pool;

    public HeartBeatManager(DynamicHostSet dynamicHostSet, int heartbeat, int heartbeatTimeout, int times, int interval, GenericKeyedObjectPool<ServerNode, T> pool) {
        this.dynamicHostSet = dynamicHostSet;
        this.heartbeat = heartbeat;
        this.heartbeatTimeout = heartbeatTimeout;
        this.times = times;
        this.interval = interval;
        this.pool = pool;
    }

    public void startHeatbeatTimer() {
        this.stopHeartbeatTimer();
        if (this.heartbeat > 0) {
            this.heatbeatTimer = this.scheduled.scheduleWithFixedDelay(new HeartBeatTask<T>(this.dynamicHostSet, this.times, this.interval, this.heartbeatTimeout, this.pool), this.heartbeat, this.heartbeat, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHeartbeatTimer() {
        try {
            ScheduledFuture<?> timer = this.heatbeatTimer;
            if (timer != null && !timer.isCancelled()) {
                timer.cancel(true);
            }
        }
        catch (Throwable t) {
            this.LOGGER.warn(t.getMessage(), t);
        }
        finally {
            this.heatbeatTimer = null;
        }
    }
}

