/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.heartbeat;

import com.bfd.harpc.common.ServerNode;
import com.bfd.harpc.loadbalance.common.DynamicHostSet;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatTask<T>
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartBeatTask.class);
    private final DynamicHostSet dynamicHostSet;
    private final int heartbeat;
    private final int heartbeatTimeout;
    private final int times;
    private final GenericKeyedObjectPool<ServerNode, T> pool;

    HeartBeatTask(DynamicHostSet dynamicHostSet, int times, int heartbeat, int heartbeatTimeout, GenericKeyedObjectPool<ServerNode, T> pool) {
        this.dynamicHostSet = dynamicHostSet;
        this.times = times;
        this.heartbeat = heartbeat;
        this.heartbeatTimeout = heartbeatTimeout;
        this.pool = pool;
    }

    @Override
    public void run() {
        for (ServerNode serverNode : this.dynamicHostSet.getAll()) {
            try {
                boolean isValid = false;
                for (int i = 0; i < this.times && !(isValid = this.checkSocket(serverNode)); ++i) {
                    Thread.sleep(this.heartbeat);
                }
                if (!isValid) {
                    if (!this.dynamicHostSet.getDeads().contains(serverNode)) {
                        this.dynamicHostSet.addDeadInstance(serverNode);
                    }
                    if (this.pool == null) continue;
                    this.pool.clear((Object)serverNode);
                    continue;
                }
                if (!this.dynamicHostSet.getDeads().contains(serverNode)) continue;
                this.dynamicHostSet.addLiveInstance(serverNode);
            }
            catch (Exception t) {
                LOGGER.warn("Exception when heartbeat to remote " + serverNode.genAddress(), (Throwable)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSocket(ServerNode serverNode) {
        boolean isValid = false;
        Socket socket = null;
        try {
            InetSocketAddress socketAddress = new InetSocketAddress(serverNode.getIp(), serverNode.getPort());
            socket = new Socket();
            socket.connect(socketAddress, this.heartbeatTimeout);
            isValid = true;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Heartbeat to remote " + serverNode.genAddress() + " success!");
            }
        }
        catch (IOException e) {
            LOGGER.warn("Heartbeat to remote " + serverNode.genAddress() + " failure!", (Throwable)e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        return isValid;
    }
}

