/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.loadbalance;

import com.bfd.harpc.heartbeat.HeartBeatManager;
import com.bfd.harpc.loadbalance.LoadBalancer;
import com.bfd.harpc.loadbalance.LoadBalancerImpl;
import com.bfd.harpc.loadbalance.LoadBalancingStrategy;
import com.bfd.harpc.loadbalance.RandomStrategy;
import com.bfd.harpc.loadbalance.RoundRobinStrategy;
import com.bfd.harpc.loadbalance.StaticLoadBalancingStrategy;
import com.bfd.harpc.loadbalance.common.DynamicSet;
import org.apache.commons.lang.StringUtils;

public class LoadBalancerFactory {
    private LoadBalancerFactory() {
    }

    public static <K, T> LoadBalancer<K> createLoadBalancer(DynamicSet<K> backends, String strategyName, HeartBeatManager<T> heartBeatManager) {
        LoadBalancingStrategy<K> loadBalancingStrategy = LoadBalancerFactory.createLoadBalancingStrategy(strategyName, heartBeatManager);
        return LoadBalancerImpl.create(loadBalancingStrategy, backends);
    }

    private static <K, T> LoadBalancingStrategy<K> createLoadBalancingStrategy(String strategyName, HeartBeatManager<T> heartBeatManager) {
        StaticLoadBalancingStrategy strategy = null;
        strategy = StringUtils.isEmpty((String)strategyName) || "round".equals(strategyName) ? new RoundRobinStrategy() : new RandomStrategy();
        return strategy;
    }
}

