/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.loadbalance;

import com.bfd.harpc.loadbalance.LoadBalancer;
import com.bfd.harpc.loadbalance.LoadBalancingStrategy;
import com.bfd.harpc.loadbalance.RequestTracker;
import com.bfd.harpc.loadbalance.common.Closure;
import com.bfd.harpc.loadbalance.common.DynamicSet;
import com.bfd.harpc.loadbalance.common.HostChangeMonitor;
import com.bfd.harpc.loadbalance.common.ResourceExhaustedException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;

public class LoadBalancerImpl<K>
implements LoadBalancer<K> {
    private final LoadBalancingStrategy<K> strategy;
    private Set<K> offeredBackends = ImmutableSet.of();

    public LoadBalancerImpl(LoadBalancingStrategy<K> strategy, DynamicSet<K> hostSet) {
        this.strategy = (LoadBalancingStrategy)Preconditions.checkNotNull(strategy);
        if (hostSet != null) {
            hostSet.monitor(new HostChangeMonitor<K>(){

                @Override
                public void onChange(ImmutableSet<K> hostAndPorts) {
                    LoadBalancerImpl.this.offerBackends(hostAndPorts);
                }
            });
        }
    }

    @Override
    public synchronized void offerBackends(Set<K> offeredBackends) {
        this.offeredBackends = ImmutableSet.copyOf(offeredBackends);
        this.strategy.offerBackends(this.offeredBackends, new Closure<Collection<K>>(){

            @Override
            public void execute(Collection<K> item) {
            }
        });
    }

    @Override
    public synchronized K nextBackend() throws ResourceExhaustedException {
        return this.strategy.nextBackend();
    }

    @Override
    public void requestResult(K key, RequestTracker.RequestResult result, long requestTimeNanos) {
        this.strategy.addConnectResult(key, result, requestTimeNanos);
    }

    public static <K> LoadBalancerImpl<K> create(LoadBalancingStrategy<K> strategy, DynamicSet<K> hostSet) {
        return new LoadBalancerImpl<K>(strategy, hostSet);
    }
}

