/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.loadbalance;

import com.bfd.harpc.loadbalance.StaticLoadBalancingStrategy;
import com.bfd.harpc.loadbalance.common.ResourceExhaustedException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class RandomStrategy<S>
extends StaticLoadBalancingStrategy<S> {
    private List<S> targets = Lists.newArrayList();
    private final Random random;

    public RandomStrategy() {
        this(new Random());
    }

    @VisibleForTesting
    RandomStrategy(Random random) {
        this.random = (Random)Preconditions.checkNotNull((Object)random);
    }

    @Override
    protected Collection<S> onBackendsOffered(Set<S> targets) {
        this.targets = ImmutableList.copyOf(targets);
        return this.targets;
    }

    @Override
    public S nextBackend() throws ResourceExhaustedException {
        if (this.targets.isEmpty()) {
            throw new ResourceExhaustedException("No backends.");
        }
        return this.targets.get(this.random.nextInt(this.targets.size()));
    }
}

