/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.loadbalance;

import com.bfd.harpc.loadbalance.StaticLoadBalancingStrategy;
import com.bfd.harpc.loadbalance.common.ResourceExhaustedException;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class RoundRobinStrategy<S>
extends StaticLoadBalancingStrategy<S> {
    private volatile Iterator<S> iterator = Iterators.emptyIterator();

    @Override
    protected Collection<S> onBackendsOffered(Set<S> targets) {
        ArrayList newTargets = Lists.newArrayList(targets);
        Collections.shuffle(newTargets);
        this.iterator = Iterators.cycle((Iterable)newTargets);
        return newTargets;
    }

    @Override
    public S nextBackend() throws ResourceExhaustedException {
        if (!this.iterator.hasNext()) {
            throw new ResourceExhaustedException("No backends available!");
        }
        return this.iterator.next();
    }
}

