/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.loadbalance.common;

import com.bfd.harpc.common.ServerNode;
import com.bfd.harpc.loadbalance.common.DynamicSet;
import com.bfd.harpc.loadbalance.common.HostChangeMonitor;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicHostSet
implements DynamicSet<ServerNode> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Set<ServerNode> all = Sets.newHashSet();
    private final Set<ServerNode> lives = Sets.newHashSet();
    private final Set<ServerNode> deads = Sets.newHashSet();
    private HostChangeMonitor<ServerNode> monitor;

    public synchronized void addServerInstance(ServerNode serverNode) {
        if (!this.lives.contains(serverNode)) {
            this.LOGGER.warn("add {} to lives set", (Object)serverNode);
            this.lives.add(serverNode);
            this.LOGGER.warn("add {} to all set", (Object)serverNode);
            this.all.add(serverNode);
            this.onChange();
        }
    }

    public synchronized void addLiveInstance(ServerNode serverNode) {
        if (this.all.contains(serverNode) && this.deads.contains(serverNode)) {
            this.lives.add(serverNode);
            this.LOGGER.warn("add {} to lives set", (Object)serverNode);
            this.deads.remove(serverNode);
            this.LOGGER.warn("remove {} from deads set", (Object)serverNode);
            this.onChange();
        }
    }

    public synchronized void addDeadInstance(ServerNode serverNode) {
        if (this.all.contains(serverNode) && this.lives.contains(serverNode)) {
            this.deads.add(serverNode);
            this.LOGGER.warn("add {} to deads set", (Object)serverNode);
            this.lives.remove(serverNode);
            this.LOGGER.warn("remove {} from lives set", (Object)serverNode);
            if (this.lives.size() == 0) {
                this.adjustAll();
            }
            this.onChange();
        }
    }

    private void adjustAll() {
        for (ServerNode serverNode : this.all) {
            this.lives.add(serverNode);
        }
        this.deads.clear();
    }

    public synchronized void replaceWithList(Collection<ServerNode> hosts) {
        String hostSetString = this.toString();
        this.all.clear();
        this.all.addAll(hosts);
        this.deads.retainAll(hosts);
        this.lives.clear();
        this.lives.addAll(hosts);
        this.lives.removeAll(this.deads);
        this.LOGGER.warn("replace " + hostSetString + " with " + this.toString());
        this.onChange();
    }

    @Override
    public void monitor(HostChangeMonitor<ServerNode> monitor) {
        this.monitor = monitor;
        this.onChange();
    }

    private void onChange() {
        if (this.monitor != null) {
            this.monitor.onChange((ImmutableSet<ServerNode>)ImmutableSet.copyOf(this.lives));
        }
    }

    public String toString() {
        return "[all=" + this.all + ", lives=" + this.lives + ", deads=" + this.deads + "]";
    }

    public Set<ServerNode> getAll() {
        return this.all;
    }

    public Set<ServerNode> getLives() {
        return this.lives;
    }

    public Set<ServerNode> getDeads() {
        return this.deads;
    }
}

