/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.main;

import com.bfd.harpc.RpcException;
import com.bfd.harpc.common.configure.PropertiesConfiguration;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigHelper.class);

    ConfigHelper() {
    }

    public static void initConfig(Object configObject, String configPrefix, PropertiesConfiguration configuration) throws RpcException {
        Method[] methods;
        for (Method method : methods = configObject.getClass().getMethods()) {
            if (method.getName().length() <= 3 || !method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
            String attribute = method.getName().substring(3);
            char ch = attribute.charAt(0);
            attribute = Character.toLowerCase(ch) + attribute.substring(1);
            String value = configuration.getProperty(configPrefix + attribute, "");
            try {
                if (!StringUtils.isNotEmpty((String)value)) continue;
                Class<?> type = method.getParameterTypes()[0];
                if (type == Boolean.TYPE) {
                    method.invoke(configObject, Boolean.valueOf(value));
                    continue;
                }
                if (type == Integer.TYPE) {
                    method.invoke(configObject, Integer.valueOf(value));
                    continue;
                }
                if (type == Long.TYPE) {
                    method.invoke(configObject, Long.valueOf(value));
                    continue;
                }
                method.invoke(configObject, value);
            }
            catch (Exception e) {
                LOGGER.error("Init config error", (Throwable)e);
                throw new RpcException(5, (Throwable)e);
            }
        }
    }
}

