/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.monitor;

import com.alibaba.fastjson.JSON;
import com.bfd.harpc.common.ServerNode;
import com.bfd.harpc.monitor.NamedThreadFactory;
import com.bfd.harpc.monitor.StatisticsHelper;
import com.bfd.harpc.monitor.StatisticsInfo;
import com.bfd.harpc.monitor.StatisticsTotal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcMonitor.class);
    private static final int NODE_COUNT_LIMIT = 600;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(3, new NamedThreadFactory("Harpc-SendStatisticsTimer", true));
    private final ScheduledFuture<?> sendFuture;
    private final long monitorInterval;
    private final CuratorFramework zkClient;
    private final String serverName;
    private final boolean isClient;
    private final ConcurrentMap<ServerNode, AtomicReference<StatisticsInfo>> statisticsMap = new ConcurrentHashMap<ServerNode, AtomicReference<StatisticsInfo>>();
    private final ConcurrentMap<ServerNode, AtomicReference<StatisticsInfo>> totalStatisticsMap = new ConcurrentHashMap<ServerNode, AtomicReference<StatisticsInfo>>();
    private final ConcurrentMap<ServerNode, Long> startTimeMap = new ConcurrentHashMap<ServerNode, Long>();
    private final ConcurrentMap<ServerNode, StatisticsTotal> statMap = new ConcurrentHashMap<ServerNode, StatisticsTotal>();
    private final long beginTime;
    private long startTime;

    public RpcMonitor(long interval, CuratorFramework zkClient, String serverName, boolean isClient) {
        this.monitorInterval = interval;
        this.zkClient = zkClient;
        this.serverName = serverName;
        this.isClient = isClient;
        this.sendFuture = this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    RpcMonitor.this.send();
                }
                catch (Throwable t) {
                    LOGGER.error(t.getMessage(), t);
                }
            }
        }, this.monitorInterval, this.monitorInterval, TimeUnit.SECONDS);
        this.beginTime = this.startTime = System.currentTimeMillis();
    }

    protected void send() {
        long useTime;
        StatisticsInfo info;
        StatisticsInfo numbers;
        AtomicReference reference;
        ServerNode serverNode;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start send statistics to zookeeper!");
        }
        for (Map.Entry entry : this.statisticsMap.entrySet()) {
            serverNode = (ServerNode)entry.getKey();
            reference = (AtomicReference)entry.getValue();
            while (!reference.compareAndSet(numbers = (StatisticsInfo)reference.get(), null)) {
            }
            info = new StatisticsInfo();
            if (numbers != null) {
                info.setSuccess(numbers.getSuccess());
                info.setFailure(numbers.getFailure());
                info.setMaxtime(numbers.getMaxtime());
                info.setMintime(numbers.getMintime());
                info.setAvgtime(numbers.getAvgtime());
                this.startTimeMap.putIfAbsent(serverNode, this.startTime);
                useTime = System.currentTimeMillis() - (Long)this.startTimeMap.get(serverNode);
                this.startTimeMap.put(serverNode, System.currentTimeMillis());
                info.setQps(1000.0f / ((float)useTime / (float)(numbers.getSuccess() + numbers.getFailure())));
            }
            this.sendToZookeeper(serverNode, info, false);
        }
        this.startTime = System.currentTimeMillis();
        for (Map.Entry entry : this.totalStatisticsMap.entrySet()) {
            serverNode = (ServerNode)entry.getKey();
            reference = (AtomicReference)entry.getValue();
            numbers = (StatisticsInfo)reference.get();
            info = new StatisticsInfo();
            if (numbers != null) {
                info.setSuccess(numbers.getSuccess());
                info.setFailure(numbers.getFailure());
                info.setMaxtime(numbers.getMaxtime());
                info.setMintime(numbers.getMintime());
                info.setAvgtime(numbers.getAvgtime());
                useTime = System.currentTimeMillis() - this.beginTime;
                info.setQps(1000.0f / ((float)useTime / (float)(numbers.getSuccess() + numbers.getFailure())));
            }
            this.sendToZookeeper(serverNode, info, true);
        }
    }

    private void sendToZookeeper(ServerNode serverNode, StatisticsInfo info, boolean isTotal) {
        StringBuilder parentPath = new StringBuilder();
        parentPath.append(this.serverName).append("/").append("statistics");
        if (this.isClient) {
            parentPath.append("/").append("clients");
        } else {
            parentPath.append("/").append("servers");
        }
        parentPath.append("/").append(serverNode.genAddress());
        String timeStamp = FastDateFormat.getInstance((String)"yyyyMMddHHmmss").format(Calendar.getInstance());
        info.setTime(timeStamp);
        if (isTotal) {
            this.statMap.putIfAbsent(serverNode, new StatisticsTotal());
            ((StatisticsTotal)this.statMap.get(serverNode)).setTotal(info);
        } else {
            this.statMap.putIfAbsent(serverNode, new StatisticsTotal());
            HashMap<String, StatisticsInfo> map = new HashMap<String, StatisticsInfo>();
            map.put(timeStamp, info);
            ((StatisticsTotal)this.statMap.get(serverNode)).getDetail().add(info);
            StatisticsHelper.adjustNodesByLimit(((StatisticsTotal)this.statMap.get(serverNode)).getDetail(), 600);
        }
        String jsonString = JSON.toJSONString(this.statMap.get(serverNode));
        String path = parentPath.toString();
        try {
            if (this.zkClient.checkExists().forPath(path) != null) {
                this.zkClient.setData().forPath(path, jsonString.getBytes());
            } else {
                ((ACLBackgroundPathAndBytesable)this.zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path, jsonString.getBytes());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void collect(ServerNode serverNode, StatisticsInfo info) {
        AtomicReference reference = (AtomicReference)this.statisticsMap.get(serverNode);
        if (reference == null) {
            this.statisticsMap.putIfAbsent(serverNode, new AtomicReference());
            reference = (AtomicReference)this.statisticsMap.get(serverNode);
        }
        this.updateStatistics(info, reference);
        AtomicReference totalReference = (AtomicReference)this.totalStatisticsMap.get(serverNode);
        if (totalReference == null) {
            this.totalStatisticsMap.putIfAbsent(serverNode, new AtomicReference());
            totalReference = (AtomicReference)this.totalStatisticsMap.get(serverNode);
        }
        this.updateStatistics(info, totalReference);
    }

    private void updateStatistics(StatisticsInfo info, AtomicReference<StatisticsInfo> reference) {
        StatisticsInfo current;
        StatisticsInfo update = new StatisticsInfo();
        do {
            if ((current = reference.get()) == null) {
                update.setSuccess(info.getSuccess());
                update.setFailure(info.getFailure());
                update.setMaxtime(info.getMaxtime());
                update.setMintime(info.getMintime());
                update.setAvgtime(info.getAvgtime());
                continue;
            }
            update.setSuccess(current.getSuccess() + info.getSuccess());
            update.setFailure(current.getFailure() + info.getFailure());
            update.setMaxtime(current.getMaxtime() > info.getMaxtime() ? current.getMaxtime() : info.getMaxtime());
            update.setMintime(current.getMintime() < info.getMintime() ? current.getMintime() : info.getMintime());
            update.setAvgtime((current.getAvgtime() * (float)(update.getSuccess() + update.getFailure()) + info.getAvgtime()) / (float)(update.getSuccess() + update.getFailure() + 1L));
        } while (!reference.compareAndSet(current, update));
    }

    public void destroy() {
        try {
            this.sendFuture.cancel(true);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
        }
    }
}

