/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.monitor;

import com.bfd.harpc.monitor.StatisticsInfo;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsHelper.class);

    public static void adjustNodesByLimit(CuratorFramework zookeeper, String parentPath, String prefix, int limit) {
        int length = prefix.length();
        try {
            List list = (List)zookeeper.getChildren().forPath(parentPath);
            while (list.size() > limit) {
                Long min = Long.MAX_VALUE;
                for (String s : list) {
                    Long tempValue;
                    if (s.length() <= length || (tempValue = new Long(s.substring(length))) >= min) continue;
                    min = tempValue;
                }
                zookeeper.delete().forPath(parentPath + "/" + prefix + min);
                list.remove(prefix + min);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void adjustNodesByLimit(List<StatisticsInfo> list, int nodeCountLimit) {
        while (list.size() > nodeCountLimit) {
            list.remove(0);
        }
    }
}

