/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.pool;

import com.bfd.harpc.RpcException;
import com.bfd.harpc.common.ServerNode;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.avro.ipc.NettyTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroClientPoolFactory<T>
extends BaseKeyedPoolableObjectFactory<ServerNode, T> {
    private final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final int timeout;
    private final Class<?> iface;
    private final ConcurrentMap<ServerNode, T> transceiverMap = new ConcurrentHashMap<ServerNode, T>();

    public AvroClientPoolFactory(int timeout, Class<?> iface) {
        this.timeout = timeout;
        this.iface = iface;
    }

    public T makeObject(ServerNode key) throws Exception {
        if (key != null) {
            Object t = null;
            if (this.transceiverMap.containsKey(key)) {
                t = this.transceiverMap.get(key);
            } else {
                NettyTransceiver nettyTransceiver = new NettyTransceiver(new InetSocketAddress(key.getIp(), key.getPort()), Long.valueOf(this.timeout));
                t = SpecificRequestor.getClient(this.iface, (Transceiver)nettyTransceiver);
            }
            return (T)t;
        }
        this.LOGGER.error("Not find a vilid server!");
        throw new RpcException("Not find a vilid server!");
    }
}

