/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.pool;

import com.bfd.harpc.RpcException;
import com.bfd.harpc.common.ServerNode;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TServiceClientPoolFactory<T>
extends BaseKeyedPoolableObjectFactory<ServerNode, T> {
    private final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final TServiceClientFactory<TServiceClient> clientFactory;
    private final int timeout;

    public TServiceClientPoolFactory(TServiceClientFactory<TServiceClient> clientFactory, int timeout) {
        this.clientFactory = clientFactory;
        this.timeout = timeout;
    }

    public T makeObject(ServerNode key) throws Exception {
        if (key != null) {
            TSocket tsocket = new TSocket(key.getIp(), key.getPort(), this.timeout);
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)tsocket);
            TServiceClient client = this.clientFactory.getClient((TProtocol)protocol);
            tsocket.open();
            return (T)client;
        }
        this.LOGGER.error("Not find a vilid server!");
        throw new RpcException("Not find a vilid server!");
    }

    public void destroyObject(ServerNode key, T client) throws Exception {
        TTransport tp = ((TServiceClient)client).getInputProtocol().getTransport();
        tp.close();
    }

    public boolean validateObject(ServerNode key, T client) {
        TTransport tp = ((TServiceClient)client).getInputProtocol().getTransport();
        return tp.isOpen();
    }
}

