/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.proxy;

import com.bfd.harpc.common.ServerNode;
import com.bfd.harpc.monitor.RpcMonitor;
import com.bfd.harpc.monitor.StatisticsInfo;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class DynamicServiceHandler
implements InvocationHandler {
    private Object target;
    private RpcMonitor monitor;
    private ServerNode serverNode;

    public Object bind(ClassLoader classLoader, Class<?> serviceClass, Object target, RpcMonitor rpcMonitor, ServerNode serverNode) throws ClassNotFoundException {
        this.target = target;
        this.monitor = rpcMonitor;
        this.serverNode = serverNode;
        return Proxy.newProxyInstance(classLoader, new Class[]{serviceClass}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean isError = false;
        StatisticsInfo info = new StatisticsInfo();
        long startTime = System.currentTimeMillis();
        try {
            Object result;
            Object object = result = method.invoke(this.target, args);
            return object;
        }
        catch (Exception e) {
            isError = true;
            throw e;
        }
        finally {
            if (this.monitor != null) {
                long usetime = System.currentTimeMillis() - startTime;
                info.setAvgtime(usetime);
                info.setMaxtime(usetime);
                info.setMintime(usetime);
                if (!isError) {
                    info.setSuccess(1L);
                } else {
                    info.setFailure(1L);
                }
                this.monitor.collect(this.serverNode, info);
            }
        }
    }
}

