/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.registry;

import com.bfd.harpc.RpcException;
import com.bfd.harpc.common.ServerNode;
import com.bfd.harpc.common.ServerNodeUtils;
import com.bfd.harpc.loadbalance.common.DynamicHostSet;
import com.bfd.harpc.registry.IRegistry;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ZkClientRegistry
implements IRegistry {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final String configPath;
    private PathChildrenCache cachedPath;
    private final CuratorFramework zookeeper;
    private final DynamicHostSet hostSet = new DynamicHostSet();
    private final ServerNode clientNode;
    private final Object lock = new Object();

    public ZkClientRegistry(String configPath, CuratorFramework zookeeper, ServerNode clientNode) {
        this.configPath = configPath;
        this.zookeeper = zookeeper;
        this.clientNode = clientNode;
    }

    @Override
    public void register(String config) throws RpcException {
        if (this.zookeeper.getState() == CuratorFrameworkState.LATENT) {
            this.zookeeper.start();
        }
        this.addListener(config);
        this.buildPathClients(config);
        this.buildPathChildrenCache(true);
        this.build();
        try {
            this.cachedPath.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean buildPathClients(String config) throws RpcException {
        if (StringUtils.isEmpty((String)this.clientNode.getExt())) {
            String address = this.clientNode.genAddress() + ":i_";
            StringBuilder pathBuilder = new StringBuilder(this.configPath);
            pathBuilder.append("/").append("clients").append("/").append(address);
            try {
                String pathName = (String)((ACLBackgroundPathAndBytesable)this.zookeeper.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(pathBuilder.toString(), config.getBytes("utf-8"));
                if (StringUtils.isNotEmpty((String)pathName)) {
                    this.clientNode.setExt(pathName.substring(pathName.indexOf(":i_") + 1));
                }
                return true;
            }
            catch (Exception e) {
                String message = MessageFormat.format("Create node error in the path : {0}", pathBuilder.toString());
                this.LOGGER.error(message, (Throwable)e);
                throw new RpcException(message, (Throwable)e);
            }
        }
        String address = this.clientNode.genAddress();
        StringBuilder pathBuilder = new StringBuilder(this.configPath);
        pathBuilder.append("/").append("clients").append("/").append(address);
        try {
            if (this.zookeeper.checkExists().forPath(pathBuilder.toString()) == null) {
                ((ACLBackgroundPathAndBytesable)this.zookeeper.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(pathBuilder.toString(), config.getBytes("utf-8"));
                return true;
            }
        }
        catch (Exception e) {
            String message = MessageFormat.format("Create node error in the path : {0}", pathBuilder.toString());
            this.LOGGER.error(message, (Throwable)e);
            throw new RpcException(message, (Throwable)e);
        }
        return false;
    }

    private void addListener(final String config) {
        this.zookeeper.getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
                block3: {
                    if (connectionState != ConnectionState.LOST) break block3;
                    try {
                        while (!curatorFramework.getZookeeperClient().blockUntilConnectedOrTimedOut() || !ZkClientRegistry.this.buildPathClients(config)) {
                        }
                    }
                    catch (Exception e) {
                        ZkClientRegistry.this.LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
    }

    private void buildPathChildrenCache(Boolean cacheData) {
        this.cachedPath = new PathChildrenCache(this.zookeeper, this.configPath + "/" + "servers", cacheData.booleanValue());
        this.cachedPath.getListenable().addListener((Object)new PathChildrenCacheListener(){

            public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) {
                PathChildrenCacheEvent.Type eventType = event.getType();
                switch (eventType) {
                    case CONNECTION_SUSPENDED: 
                    case CONNECTION_LOST: {
                        ZkClientRegistry.this.LOGGER.error("Connection error,waiting...");
                        return;
                    }
                }
                try {
                    ZkClientRegistry.this.cachedPath.rebuild();
                    ZkClientRegistry.this.rebuild();
                }
                catch (Exception e) {
                    ZkClientRegistry.this.LOGGER.error("CachedPath rebuild error!", (Throwable)e);
                }
            }
        });
    }

    private void build() throws RpcException {
        List childrenList = null;
        String path = this.configPath + "/" + "servers";
        try {
            childrenList = (List)this.zookeeper.getChildren().forPath(path);
        }
        catch (Exception e) {
            String message = MessageFormat.format("Get children node error in the path : {0}", path);
            this.LOGGER.error(message, (Throwable)e);
            throw new RpcException(message, (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)childrenList)) {
            this.LOGGER.error("Not find a service in zookeeper!");
            throw new RpcException("Not find a service in zookeeper!");
        }
        ArrayList<ServerNode> current = new ArrayList<ServerNode>();
        for (String children : childrenList) {
            current.addAll(ServerNodeUtils.transfer(children));
        }
        this.freshContainer(current);
    }

    protected void rebuild() {
        List children = this.cachedPath.getCurrentData();
        if (children == null || children.isEmpty()) {
            this.LOGGER.error("Thrift server-cluster error!");
            return;
        }
        ArrayList<ServerNode> current = new ArrayList<ServerNode>();
        for (ChildData data : children) {
            String path = data.getPath();
            String address = path.substring(path.lastIndexOf("/") + 1);
            this.LOGGER.debug("Server address {}.", (Object)address);
            current.addAll(ServerNodeUtils.transfer(address));
        }
        this.freshContainer(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freshContainer(List<ServerNode> current) {
        Object object = this.lock;
        synchronized (object) {
            this.hostSet.replaceWithList(current);
        }
    }

    @Override
    public DynamicHostSet findAllService() {
        return this.hostSet;
    }

    @Override
    public void unregister() {
        try {
            this.cachedPath.close();
            this.zookeeper.close();
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

