/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.registry;

import com.bfd.harpc.RpcException;
import com.bfd.harpc.loadbalance.common.DynamicHostSet;
import com.bfd.harpc.registry.IRegistry;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkServerRegistry
implements IRegistry {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework zookeeper;
    private final String zkPath;
    private final String address;
    private final String auth;

    public ZkServerRegistry(CuratorFramework zookeeper, String zkPath, String address, String auth) {
        this.zookeeper = zookeeper;
        this.zkPath = zkPath;
        this.address = address;
        this.auth = auth;
    }

    @Override
    public void register(String config) throws RpcException {
        if (this.zookeeper.getState() == CuratorFrameworkState.LATENT) {
            this.zookeeper.start();
            this.zookeeper.newNamespaceAwareEnsurePath(this.zkPath);
        }
        this.addListener(config);
        this.build(config);
    }

    private void addListener(final String config) {
        this.zookeeper.getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
                block3: {
                    if (connectionState != ConnectionState.LOST) break block3;
                    try {
                        while (!curatorFramework.getZookeeperClient().blockUntilConnectedOrTimedOut() || !ZkServerRegistry.this.build(config)) {
                        }
                    }
                    catch (Exception e) {
                        ZkServerRegistry.this.LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
    }

    private boolean build(String config) throws RpcException {
        this.createParentsNode();
        StringBuilder pathBuilder = new StringBuilder(this.zkPath);
        pathBuilder.append("/").append("servers").append("/").append(this.address);
        try {
            if (this.zookeeper.checkExists().forPath(pathBuilder.toString()) == null) {
                ((ACLBackgroundPathAndBytesable)this.zookeeper.create().withMode(CreateMode.EPHEMERAL)).forPath(pathBuilder.toString(), config.getBytes("utf-8"));
                return true;
            }
        }
        catch (Exception e) {
            String message = MessageFormat.format("Create node error in the path : {0}", pathBuilder.toString());
            this.LOGGER.error(message, (Throwable)e);
            throw new RpcException(message, (Throwable)e);
        }
        return false;
    }

    private void createParentsNode() throws RpcException {
        String parentPath = this.zkPath + "/" + "servers";
        try {
            if (this.zookeeper.checkExists().forPath(parentPath) == null) {
                Id id = new Id("digest", DigestAuthenticationProvider.generateDigest((String)this.auth));
                ArrayList<ACL> acls = new ArrayList<ACL>(2);
                ACL acl = new ACL(4, id);
                Id id2 = new Id("world", "anyone");
                ACL acl2 = new ACL(1, id2);
                acls.add(acl);
                acls.add(acl2);
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.zookeeper.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).withACL(acls)).forPath(parentPath);
            }
        }
        catch (Exception e) {
            String message = MessageFormat.format("Zookeeper error in the path : {0}", parentPath);
            this.LOGGER.error(message, (Throwable)e);
            throw new RpcException(message, (Throwable)e);
        }
    }

    @Override
    public DynamicHostSet findAllService() {
        return null;
    }

    @Override
    public void unregister() {
        this.zookeeper.close();
    }
}

