/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.server.avro;

import com.bfd.harpc.RpcException;
import com.bfd.harpc.common.ServerNode;
import com.bfd.harpc.monitor.RpcMonitor;
import com.bfd.harpc.server.IServer;
import com.bfd.harpc.server.avro.AvroRpcPlugin;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.avro.ipc.NettyServer;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Responder;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroServer
implements IServer {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final NettyServer nettyServer;
    private boolean isStarted = false;

    public AvroServer(Responder responder, ServerNode serverNode, int maxWorkerThreads, int minWorkerThreads, RpcMonitor monitor) throws RpcException {
        NioServerSocketChannelFactory channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        responder.addRPCPlugin((RPCPlugin)new AvroRpcPlugin(monitor, serverNode));
        this.nettyServer = new NettyServer(responder, new InetSocketAddress(serverNode.getPort()), (ChannelFactory)channelFactory);
    }

    @Override
    public void start() {
        if (!this.isStarted) {
            this.nettyServer.start();
            this.isStarted = true;
            System.out.println("Server is start!");
            this.LOGGER.info("Server is start!");
        }
    }

    @Override
    public void stop() {
        if (this.isStarted) {
            this.nettyServer.close();
            this.isStarted = false;
            System.out.println("Server is closed!");
            this.LOGGER.info("Server is closed!");
        }
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }
}

