/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.server.thrift;

import com.bfd.harpc.RpcException;
import com.bfd.harpc.common.ServerNode;
import com.bfd.harpc.monitor.RpcMonitor;
import com.bfd.harpc.server.thrift.ThriftEventHandler;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TServerThread
extends Thread {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final TServer server;

    public TServerThread(TProcessor processor, ServerNode serverNode, int maxWorkerThreads, int minWorkerThreads, RpcMonitor monitor) throws RpcException {
        TServerSocket serverTransport;
        try {
            serverTransport = new TServerSocket(serverNode.getPort());
        }
        catch (TTransportException e) {
            throw new RpcException(1, (Throwable)e);
        }
        TBinaryProtocol.Factory portFactory = new TBinaryProtocol.Factory(true, true);
        TThreadPoolServer.Args args = new TThreadPoolServer.Args((TServerTransport)serverTransport);
        args.processor(processor);
        args.protocolFactory((TProtocolFactory)portFactory);
        args.maxWorkerThreads(maxWorkerThreads);
        args.minWorkerThreads(minWorkerThreads);
        this.server = new TThreadPoolServer(args);
        this.server.setServerEventHandler((TServerEventHandler)new ThriftEventHandler(monitor, serverNode));
        this.setName("Harpc-Thrift-Server");
    }

    public TServerThread(TServer tServer) {
        this.server = tServer;
    }

    @Override
    public void run() {
        try {
            System.out.println("Server is start!");
            this.LOGGER.info("Server is start!");
            this.server.serve();
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void stopServer() {
        this.server.stop();
        System.out.println("Server is stop!");
        this.LOGGER.info("Server is stop!");
    }

    public boolean isStarted() {
        return this.server.isServing();
    }
}

