/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.harpc.server.thrift;

import com.bfd.harpc.RpcException;
import com.bfd.harpc.common.ServerNode;
import com.bfd.harpc.monitor.RpcMonitor;
import com.bfd.harpc.server.IServer;
import com.bfd.harpc.server.thrift.TServerThread;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftServer
implements IServer {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final TServerThread serverThread;
    private boolean isStarted = false;

    public ThriftServer(TServer server) {
        this.serverThread = new TServerThread(server);
    }

    public ThriftServer(TProcessor processor, ServerNode serverNode, int maxWorkerThreads, int minWorkerThreads, RpcMonitor monitor) throws RpcException {
        this.serverThread = new TServerThread(processor, serverNode, maxWorkerThreads, minWorkerThreads, monitor);
    }

    @Override
    public void start() {
        if (!this.isStarted) {
            this.serverThread.start();
            this.isStarted = this.serverThread.isStarted();
        }
    }

    @Override
    public void stop() {
        if (this.isStarted) {
            this.serverThread.stopServer();
            this.isStarted = false;
        }
    }

    @Override
    public boolean isStarted() {
        int i = 0;
        while (!this.isStarted && i < 3) {
            this.isStarted = this.serverThread.isStarted();
            try {
                Thread.sleep(100 * i++);
            }
            catch (InterruptedException e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.isStarted;
    }
}

