/*
 * Decompiled with CFR 0.152.
 */
package com.bakdata.common_kafka_streams;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringJoiner;

public class EnvironmentArgumentsParser {
    private final String environmentPrefix;
    private final String commandLineDelimiter;
    private final String environmentDelimiter;

    public EnvironmentArgumentsParser(String environmentPrefix) {
        this(environmentPrefix, "-", "_");
    }

    public EnvironmentArgumentsParser(String environmentPrefix, String commandLineDelimiter, String environmentDelimiter) {
        this.environmentPrefix = environmentPrefix;
        this.commandLineDelimiter = commandLineDelimiter;
        this.environmentDelimiter = environmentDelimiter;
    }

    public String[] parseVariables(Map<String, String> environment) {
        ArrayList environmentArguments = new ArrayList();
        environment.forEach((k, v) -> {
            if (!k.startsWith(this.environmentPrefix)) {
                return;
            }
            environmentArguments.add(this.convertEnvironmentKeyToCommandLineParameter((String)k));
            environmentArguments.add(v);
        });
        return environmentArguments.toArray(new String[0]);
    }

    private String convertEnvironmentKeyToCommandLineParameter(String environmentKey) {
        String[] words;
        StringJoiner sj = new StringJoiner(this.commandLineDelimiter);
        for (String word : words = environmentKey.split(this.environmentPrefix)[1].split(this.environmentDelimiter)) {
            sj.add(word.toLowerCase());
        }
        return "--" + sj;
    }
}

