/*
 * Decompiled with CFR 0.152.
 */
package com.bakdata.common_kafka_streams;

import com.bakdata.common_kafka_streams.EnvironmentArgumentsParser;
import io.confluent.kafka.streams.serdes.avro.SpecificAvroSerde;
import java.io.PrintStream;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.Topology;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import picocli.CommandLine;

public abstract class KafkaStreamsApplication
implements Runnable {
    @CommandLine.Option(names={"--brokers"}, required=true)
    private String brokers = "";
    @CommandLine.Option(names={"--schema-registry-url"}, required=true)
    private String schemaRegistryUrl = "";
    @CommandLine.Option(names={"--productive"}, required=false)
    private boolean productive = true;
    @CommandLine.Option(names={"--debug"}, required=false)
    private boolean debug = false;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"print this help and exit"})
    private boolean helpRequested = false;
    private KafkaStreams streams;
    private static final String ENV_PREFIX = Optional.ofNullable(System.getenv("ENV_PREFIX")).orElse("APP_");

    private static String[] addEnvironmentVariablesArguments(String[] args) {
        Object[] environmentArguments = new EnvironmentArgumentsParser(ENV_PREFIX).parseVariables(System.getenv());
        return (String[])ArrayUtils.addAll((Object[])args, (Object[])environmentArguments);
    }

    protected static void startApplication(KafkaStreamsApplication app, String[] args) {
        String[] populatedArgs = KafkaStreamsApplication.addEnvironmentVariablesArguments(args);
        CommandLine.run((Runnable)app, (PrintStream)System.out, (String[])populatedArgs);
    }

    @Override
    public void run() {
        if (this.debug) {
            Logger.getLogger((String)"com.bakdata").setLevel(Level.DEBUG);
        }
        Properties kafkaProperties = this.getKafkaProperties();
        this.streams = new KafkaStreams(this.createTopology(), kafkaProperties);
        this.streams.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.streams.close()));
    }

    public abstract void buildTopology(StreamsBuilder var1);

    public Topology createTopology() {
        StreamsBuilder builder = new StreamsBuilder();
        this.buildTopology(builder);
        return builder.build();
    }

    public Properties getKafkaProperties() {
        Properties kafkaConfig = new Properties();
        kafkaConfig.setProperty("processing.guarantee", "exactly_once");
        kafkaConfig.put(StreamsConfig.producerPrefix((String)"max.in.flight.requests.per.connection"), (Object)1);
        if (this.productive) {
            kafkaConfig.put("replication.factor", (Object)3);
        }
        kafkaConfig.setProperty(StreamsConfig.producerPrefix((String)"acks"), "all");
        kafkaConfig.setProperty(StreamsConfig.producerPrefix((String)"compression.type"), "gzip");
        kafkaConfig.setProperty("application.id", this.getClass().getSimpleName());
        kafkaConfig.put("default.key.serde", SpecificAvroSerde.class);
        kafkaConfig.put("default.value.serde", SpecificAvroSerde.class);
        kafkaConfig.setProperty("schema.registry.url", this.getSchemaRegistryUrl());
        kafkaConfig.setProperty("bootstrap.servers", this.getBrokers());
        return kafkaConfig;
    }

    public String getBrokers() {
        return this.brokers;
    }

    public String getSchemaRegistryUrl() {
        return this.schemaRegistryUrl;
    }

    public boolean isProductive() {
        return this.productive;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isHelpRequested() {
        return this.helpRequested;
    }

    public KafkaStreams getStreams() {
        return this.streams;
    }

    public void setBrokers(String brokers) {
        this.brokers = brokers;
    }

    public void setSchemaRegistryUrl(String schemaRegistryUrl) {
        this.schemaRegistryUrl = schemaRegistryUrl;
    }

    public void setProductive(boolean productive) {
        this.productive = productive;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setHelpRequested(boolean helpRequested) {
        this.helpRequested = helpRequested;
    }

    public void setStreams(KafkaStreams streams) {
        this.streams = streams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaStreamsApplication)) {
            return false;
        }
        KafkaStreamsApplication other = (KafkaStreamsApplication)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$brokers = this.getBrokers();
        String other$brokers = other.getBrokers();
        if (this$brokers == null ? other$brokers != null : !this$brokers.equals(other$brokers)) {
            return false;
        }
        String this$schemaRegistryUrl = this.getSchemaRegistryUrl();
        String other$schemaRegistryUrl = other.getSchemaRegistryUrl();
        if (this$schemaRegistryUrl == null ? other$schemaRegistryUrl != null : !this$schemaRegistryUrl.equals(other$schemaRegistryUrl)) {
            return false;
        }
        if (this.isProductive() != other.isProductive()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isHelpRequested() != other.isHelpRequested()) {
            return false;
        }
        KafkaStreams this$streams = this.getStreams();
        KafkaStreams other$streams = other.getStreams();
        return !(this$streams == null ? other$streams != null : !this$streams.equals(other$streams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaStreamsApplication;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $brokers = this.getBrokers();
        result = result * 59 + ($brokers == null ? 43 : $brokers.hashCode());
        String $schemaRegistryUrl = this.getSchemaRegistryUrl();
        result = result * 59 + ($schemaRegistryUrl == null ? 43 : $schemaRegistryUrl.hashCode());
        result = result * 59 + (this.isProductive() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isHelpRequested() ? 79 : 97);
        KafkaStreams $streams = this.getStreams();
        result = result * 59 + ($streams == null ? 43 : $streams.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaStreamsApplication(brokers=" + this.getBrokers() + ", schemaRegistryUrl=" + this.getSchemaRegistryUrl() + ", productive=" + this.isProductive() + ", debug=" + this.isDebug() + ", helpRequested=" + this.isHelpRequested() + ", streams=" + this.getStreams() + ")";
    }
}

