/*
 * Decompiled with CFR 0.152.
 */
package com.bakdata.schemaregistrymock;

import com.bakdata.schemaregistrymock.SchemaRegistryMock;
import com.bakdata.schemaregistrymock.SubjectsHandler;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import java.io.IOException;

class GetSubjectSchemaVersionHandler
extends SubjectsHandler {
    private final SchemaRegistryMock schemaRegistryMock;

    GetSubjectSchemaVersionHandler(SchemaRegistryMock schemaRegistryMock) {
        this.schemaRegistryMock = schemaRegistryMock;
    }

    public ResponseDefinition transform(ServeEvent serveEvent) {
        String subject = GetSubjectSchemaVersionHandler.removeQueryParameters(this.getSubject((Request)serveEvent.getRequest()));
        try {
            RegisterSchemaRequest schemaRequest = RegisterSchemaRequest.fromJson((String)serveEvent.getRequest().getBodyAsString());
            ParsedSchema parsedSchema = this.schemaRegistryMock.parseSchema(schemaRequest);
            Schema schema = this.schemaRegistryMock.getSchema(subject, parsedSchema);
            return ResponseDefinitionBuilder.jsonResponse((Object)schema);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot parse schema registration request", e);
        }
    }

    public String getName() {
        return GetSubjectSchemaVersionHandler.class.getSimpleName();
    }
}

