/*
 * Decompiled with CFR 0.152.
 */
package com.bakdata.schemaregistrymock;

import com.bakdata.schemaregistrymock.SchemaRegistryMock;
import com.bakdata.schemaregistrymock.SubjectsHandler;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.google.common.collect.Iterables;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import java.io.IOException;

class AutoRegistrationHandler
extends SubjectsHandler {
    private final SchemaRegistryMock schemaRegistryMock;

    AutoRegistrationHandler(SchemaRegistryMock schemaRegistryMock) {
        this.schemaRegistryMock = schemaRegistryMock;
    }

    public ResponseDefinition transform(ServeEvent serveEvent) {
        String subject = (String)Iterables.get((Iterable)this.urlSplitter.split((CharSequence)serveEvent.getRequest().getUrl()), (int)1);
        try {
            RegisterSchemaRequest schemaRequest = RegisterSchemaRequest.fromJson((String)serveEvent.getRequest().getBodyAsString());
            ParsedSchema schema = this.schemaRegistryMock.parseSchema(schemaRequest);
            int id = this.schemaRegistryMock.register(subject, schema);
            RegisterSchemaResponse registerSchemaResponse = new RegisterSchemaResponse();
            registerSchemaResponse.setId(id);
            return ResponseDefinitionBuilder.jsonResponse((Object)registerSchemaResponse);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot parse schema registration request", e);
        }
    }

    public String getName() {
        return AutoRegistrationHandler.class.getSimpleName();
    }
}

