/*
 * Decompiled with CFR 0.152.
 */
package com.bakdata.schemaregistrymock;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformerV2;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import io.confluent.kafka.schemaregistry.client.rest.entities.ErrorMessage;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ErrorResponseTransformer
implements ResponseDefinitionTransformerV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorResponseTransformer.class);
    public static final int INTERNAL_SERVER_ERROR_CODE = 500;
    private final ResponseDefinitionTransformerV2 transformer;

    public ResponseDefinition transform(ServeEvent serveEvent) {
        try {
            return this.transformer.transform(serveEvent);
        }
        catch (RuntimeException e) {
            log.warn("An exception occurred while handling the schema registry request '{} {}'", new Object[]{serveEvent.getRequest().getMethod(), serveEvent.getRequest().getUrl(), e});
            ErrorMessage body = new ErrorMessage(500, e.getMessage());
            return ResponseDefinitionBuilder.jsonResponse((Object)body, (int)500);
        }
    }

    public String getName() {
        return this.transformer.getName();
    }

    public boolean applyGlobally() {
        return this.transformer.applyGlobally();
    }

    @Generated
    public ErrorResponseTransformer(ResponseDefinitionTransformerV2 transformer) {
        this.transformer = transformer;
    }
}

