/*
 * Decompiled with CFR 0.152.
 */
package com.bakdata.kafka;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnvironmentArgumentsParser {
    private final String environmentPrefix;
    private final String commandLineDelimiter;
    private final String environmentDelimiter;

    public EnvironmentArgumentsParser(String environmentPrefix) {
        this(environmentPrefix, "-", "_");
    }

    public EnvironmentArgumentsParser(String environmentPrefix, String commandLineDelimiter, String environmentDelimiter) {
        this.environmentPrefix = environmentPrefix;
        this.commandLineDelimiter = commandLineDelimiter;
        this.environmentDelimiter = environmentDelimiter;
    }

    public List<String> parseVariables(Map<String, String> environment) {
        return environment.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(this.environmentPrefix)).flatMap(this::convertEnvironmentVariable).collect(Collectors.toList());
    }

    private String convertEnvironmentKeyToCommandLineParameter(String environmentKey) {
        String[] words;
        StringJoiner sj = new StringJoiner(this.commandLineDelimiter);
        for (String word : words = environmentKey.replaceAll("^" + Pattern.quote(this.environmentPrefix), "").split(this.environmentDelimiter)) {
            sj.add(word.toLowerCase());
        }
        return "--" + sj;
    }

    private Stream<String> convertEnvironmentVariable(Map.Entry<String, String> environmentEntry) {
        String key = this.convertEnvironmentKeyToCommandLineParameter(environmentEntry.getKey());
        return Stream.of(key, environmentEntry.getValue());
    }
}

