/*
 * Decompiled with CFR 0.152.
 */
package com.bakdata.kafka;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class EnvironmentStreamsConfigParser {
    static final String PREFIX = "STREAMS_";
    private static final Pattern UNDERSCORE = Pattern.compile("_");
    private static final Pattern PREFIX_PATTERN = Pattern.compile("^STREAMS_");

    private EnvironmentStreamsConfigParser() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static Map<String, String> parseVariables(Map<String, String> environment) {
        return environment.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(PREFIX)).collect(Collectors.toMap(EnvironmentStreamsConfigParser::convertEnvironmentVariable, Map.Entry::getValue));
    }

    private static String convertEnvironmentVariable(Map.Entry<String, String> environmentEntry) {
        String key = environmentEntry.getKey();
        String withoutPrefix = PREFIX_PATTERN.matcher(key).replaceAll("");
        return UNDERSCORE.matcher(withoutPrefix).replaceAll(".").toLowerCase();
    }
}

