/*
 * Decompiled with CFR 0.152.
 */
package com.bakdata.kafka;

import com.bakdata.kafka.EnvironmentArgumentsParser;
import com.bakdata.kafka.EnvironmentStreamsConfigParser;
import com.bakdata.kafka.util.ImprovedAdminClient;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import picocli.CommandLine;

public abstract class KafkaApplication
implements Runnable {
    public static final int RESET_SLEEP_MS = 5000;
    private static final String ENV_PREFIX = Optional.ofNullable(System.getenv("ENV_PREFIX")).orElse("APP_");
    public static final Duration ADMIN_TIMEOUT = Duration.ofSeconds(10L);
    @CommandLine.Option(names={"--output-topic"}, description={"Output topic"})
    protected String outputTopic = "";
    @CommandLine.Option(names={"--extra-output-topics"}, split=",", description={"Additional output topics"})
    protected Map<String, String> extraOutputTopics = new HashMap<String, String>();
    @CommandLine.Option(names={"--brokers"}, required=true)
    protected String brokers = "";
    @CommandLine.Option(names={"--debug"}, arity="0..1")
    protected boolean debug = false;
    @CommandLine.Option(names={"--clean-up"}, arity="0..1", description={"Clear the state store and the global Kafka offsets for the consumer group. Be careful with running in production and with enabling this flag - it might cause inconsistent processing with multiple replicas."})
    protected boolean cleanUp = false;
    @CommandLine.Option(names={"--schema-registry-url"}, required=true)
    private String schemaRegistryUrl = "";
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"print this help and exit"})
    private boolean helpRequested = false;
    @CommandLine.Option(names={"--streams-config"}, split=",", description={"Additional Kafka properties"})
    private Map<String, String> streamsConfig = new HashMap<String, String>();

    static String[] addEnvironmentVariablesArguments(String[] args) {
        Preconditions.checkArgument((!ENV_PREFIX.equals("STREAMS_") ? 1 : 0) != 0, (Object)"Prefix 'STREAMS_' is reserved for Streams config");
        List<String> environmentArguments = new EnvironmentArgumentsParser(ENV_PREFIX).parseVariables(System.getenv());
        ArrayList<String> allArgs = new ArrayList<String>(environmentArguments);
        allArgs.addAll(Arrays.asList(args));
        return (String[])allArgs.toArray(String[]::new);
    }

    public final Properties getKafkaProperties() {
        Properties kafkaConfig = this.createKafkaProperties();
        EnvironmentStreamsConfigParser.parseVariables(System.getenv()).forEach(kafkaConfig::setProperty);
        this.streamsConfig.forEach(kafkaConfig::setProperty);
        return kafkaConfig;
    }

    public String getOutputTopic(String role) {
        String topic = this.extraOutputTopics.get(role);
        Preconditions.checkNotNull((Object)topic, (String)"No output topic for role '%s' available", (Object)role);
        return topic;
    }

    public ImprovedAdminClient createAdminClient() {
        return ImprovedAdminClient.builder().properties(this.createKafkaProperties()).schemaRegistryUrl(this.getSchemaRegistryUrl()).timeout(ADMIN_TIMEOUT).build();
    }

    protected abstract Properties createKafkaProperties();

    protected abstract void runCleanUp();

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "KafkaApplication(outputTopic=" + this.getOutputTopic() + ", extraOutputTopics=" + this.getExtraOutputTopics() + ", brokers=" + this.getBrokers() + ", debug=" + this.isDebug() + ", cleanUp=" + this.isCleanUp() + ", schemaRegistryUrl=" + this.getSchemaRegistryUrl() + ", helpRequested=" + this.isHelpRequested() + ", streamsConfig=" + this.getStreamsConfig() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getOutputTopic() {
        return this.outputTopic;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, String> getExtraOutputTopics() {
        return this.extraOutputTopics;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getBrokers() {
        return this.brokers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isCleanUp() {
        return this.cleanUp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSchemaRegistryUrl() {
        return this.schemaRegistryUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isHelpRequested() {
        return this.helpRequested;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, String> getStreamsConfig() {
        return this.streamsConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setOutputTopic(String outputTopic) {
        this.outputTopic = outputTopic;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setExtraOutputTopics(Map<String, String> extraOutputTopics) {
        this.extraOutputTopics = extraOutputTopics;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setBrokers(String brokers) {
        this.brokers = brokers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCleanUp(boolean cleanUp) {
        this.cleanUp = cleanUp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSchemaRegistryUrl(String schemaRegistryUrl) {
        this.schemaRegistryUrl = schemaRegistryUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setHelpRequested(boolean helpRequested) {
        this.helpRequested = helpRequested;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStreamsConfig(Map<String, String> streamsConfig) {
        this.streamsConfig = streamsConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KafkaApplication() {
    }
}

