/*
 * Decompiled with CFR 0.152.
 */
package com.bakdata.kafka.util;

import com.bakdata.kafka.util.KafkaAdminException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import lombok.NonNull;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsumerGroupClient
implements Closeable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsumerGroupClient.class);
    @NonNull
    private final AdminClient adminClient;
    @NonNull
    private final Duration timeout;

    public static ConsumerGroupClient create(Map<String, Object> configs, Duration timeout) {
        return new ConsumerGroupClient(AdminClient.create(configs), timeout);
    }

    public static ConsumerGroupClient create(Properties configs, Duration timeout) {
        return new ConsumerGroupClient(AdminClient.create((Properties)configs), timeout);
    }

    public void deleteConsumerGroup(String groupName) {
        log.info("Deleting consumer group '{}'", (Object)groupName);
        try {
            this.adminClient.deleteConsumerGroups(List.of(groupName)).all().get(this.timeout.toSeconds(), TimeUnit.SECONDS);
            log.info("Deleted consumer group'{}'", (Object)groupName);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new KafkaAdminException("Failed to delete consumer group " + groupName, ex);
        }
        catch (ExecutionException | TimeoutException ex) {
            throw new KafkaAdminException("Failed to delete consumer group " + groupName, ex);
        }
    }

    @Override
    public void close() {
        this.adminClient.close();
    }

    public boolean exists(String groupName) {
        Collection<ConsumerGroupListing> consumerGroups = this.listGroups();
        return consumerGroups.stream().anyMatch(c -> c.groupId().equals(groupName));
    }

    public Collection<ConsumerGroupListing> listGroups() {
        try {
            return (Collection)this.adminClient.listConsumerGroups().all().get(this.timeout.toSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new KafkaAdminException("Failed to list consumer groups", ex);
        }
        catch (ExecutionException | TimeoutException ex) {
            throw new KafkaAdminException("Failed to list consumer groups", ex);
        }
    }

    public void deleteGroupIfExists(String groupName) {
        if (this.exists(groupName)) {
            this.deleteConsumerGroup(groupName);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConsumerGroupClient(@NonNull AdminClient adminClient, @NonNull Duration timeout) {
        if (adminClient == null) {
            throw new NullPointerException("adminClient is marked non-null but is null");
        }
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
        this.adminClient = adminClient;
        this.timeout = timeout;
    }
}

