/*
 * Decompiled with CFR 0.152.
 */
package com.bakdata.kafka.util;

import com.bakdata.kafka.util.ConsumerGroupClient;
import com.bakdata.kafka.util.SchemaTopicClient;
import com.bakdata.kafka.util.TopicClient;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.io.Closeable;
import java.time.Duration;
import java.util.Properties;
import lombok.Generated;
import lombok.NonNull;
import org.apache.kafka.clients.admin.AdminClient;

public final class ImprovedAdminClient
implements Closeable {
    @NonNull
    private final Properties properties;
    @NonNull
    private final AdminClient adminClient;
    @NonNull
    private final SchemaRegistryClient schemaRegistryClient;
    @NonNull
    private final Duration timeout;

    private ImprovedAdminClient(@NonNull Properties properties, @NonNull String schemaRegistryUrl, @NonNull Duration timeout) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (schemaRegistryUrl == null) {
            throw new NullPointerException("schemaRegistryUrl is marked non-null but is null");
        }
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
        Preconditions.checkNotNull((Object)properties.getProperty("bootstrap.servers"), (String)"%s must be specified in properties", (Object)"bootstrap.servers");
        this.properties = properties;
        this.adminClient = AdminClient.create((Properties)properties);
        this.schemaRegistryClient = SchemaTopicClient.createSchemaRegistryClient(properties, schemaRegistryUrl);
        this.timeout = timeout;
    }

    public SchemaTopicClient getSchemaTopicClient() {
        return new SchemaTopicClient(this.getTopicClient(), this.schemaRegistryClient);
    }

    public TopicClient getTopicClient() {
        return new TopicClient(this.adminClient, this.timeout);
    }

    public ConsumerGroupClient getConsumerGroupClient() {
        return new ConsumerGroupClient(this.adminClient, this.timeout);
    }

    public String getBootstrapServers() {
        return this.properties.getProperty("bootstrap.servers");
    }

    @Override
    public void close() {
        this.adminClient.close();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ImprovedAdminClientBuilder builder() {
        return new ImprovedAdminClientBuilder();
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SchemaRegistryClient getSchemaRegistryClient() {
        return this.schemaRegistryClient;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ImprovedAdminClientBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Properties properties;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String schemaRegistryUrl;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Duration timeout;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ImprovedAdminClientBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ImprovedAdminClientBuilder properties(@NonNull Properties properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties = properties;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ImprovedAdminClientBuilder schemaRegistryUrl(@NonNull String schemaRegistryUrl) {
            if (schemaRegistryUrl == null) {
                throw new NullPointerException("schemaRegistryUrl is marked non-null but is null");
            }
            this.schemaRegistryUrl = schemaRegistryUrl;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ImprovedAdminClientBuilder timeout(@NonNull Duration timeout) {
            if (timeout == null) {
                throw new NullPointerException("timeout is marked non-null but is null");
            }
            this.timeout = timeout;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ImprovedAdminClient build() {
            return new ImprovedAdminClient(this.properties, this.schemaRegistryUrl, this.timeout);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ImprovedAdminClient.ImprovedAdminClientBuilder(properties=" + this.properties + ", schemaRegistryUrl=" + this.schemaRegistryUrl + ", timeout=" + this.timeout + ")";
        }
    }
}

