/*
 * Decompiled with CFR 0.152.
 */
package com.bakdata.kafka.util;

import com.bakdata.kafka.util.TopicClient;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaTopicClient
implements Closeable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaTopicClient.class);
    @NonNull
    private final TopicClient topicClient;
    @NonNull
    private final SchemaRegistryClient schemaRegistryClient;

    public static SchemaTopicClient create(Properties configs, String schemaRegistryUrl, Duration timeout) {
        CachedSchemaRegistryClient schemaRegistryClient = SchemaTopicClient.createSchemaRegistryClient(configs, schemaRegistryUrl);
        TopicClient topicClient = TopicClient.create(configs, timeout);
        return new SchemaTopicClient(topicClient, (SchemaRegistryClient)schemaRegistryClient);
    }

    public static CachedSchemaRegistryClient createSchemaRegistryClient(@NonNull Map<Object, Object> configs, @NonNull String schemaRegistryUrl) {
        if (configs == null) {
            throw new NullPointerException("configs is marked non-null but is null");
        }
        if (schemaRegistryUrl == null) {
            throw new NullPointerException("schemaRegistryUrl is marked non-null but is null");
        }
        HashMap originals = new HashMap();
        configs.forEach((key, value) -> originals.put(key.toString(), value));
        return new CachedSchemaRegistryClient(schemaRegistryUrl, 100, originals);
    }

    public void deleteTopicAndResetSchemaRegistry(String topic) {
        this.topicClient.deleteTopicIfExists(topic);
        this.resetSchemaRegistry(topic);
    }

    public void resetSchemaRegistry(String topic) {
        log.info("Resetting schema registry for topic '{}'", (Object)topic);
        try {
            Collection allSubjects = this.schemaRegistryClient.getAllSubjects();
            String keySubject = topic + "-key";
            if (allSubjects.contains(keySubject)) {
                this.schemaRegistryClient.deleteSubject(keySubject);
                log.info("Cleaned key schema of topic {}", (Object)topic);
            } else {
                log.info("No key schema for topic {} available", (Object)topic);
            }
            String valueSubject = topic + "-value";
            if (allSubjects.contains(valueSubject)) {
                this.schemaRegistryClient.deleteSubject(valueSubject);
                log.info("Cleaned value schema of topic {}", (Object)topic);
            } else {
                log.info("No value schema for topic {} available", (Object)topic);
            }
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException("Could not reset schema registry for topic " + topic, e);
        }
    }

    @Override
    public void close() {
        this.topicClient.close();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SchemaTopicClient(@NonNull TopicClient topicClient, @NonNull SchemaRegistryClient schemaRegistryClient) {
        if (topicClient == null) {
            throw new NullPointerException("topicClient is marked non-null but is null");
        }
        if (schemaRegistryClient == null) {
            throw new NullPointerException("schemaRegistryClient is marked non-null but is null");
        }
        this.topicClient = topicClient;
        this.schemaRegistryClient = schemaRegistryClient;
    }
}

