/*
 * Decompiled with CFR 0.152.
 */
package com.bakdata.kafka.util;

import com.bakdata.kafka.util.KafkaAdminException;
import com.bakdata.kafka.util.TopicSettings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import lombok.NonNull;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TopicClient
implements Closeable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopicClient.class);
    @NonNull
    private final AdminClient adminClient;
    @NonNull
    private final Duration timeout;

    public static TopicClient create(Map<String, Object> configs, Duration timeout) {
        return new TopicClient(AdminClient.create(configs), timeout);
    }

    public static TopicClient create(Properties configs, Duration timeout) {
        return new TopicClient(AdminClient.create((Properties)configs), timeout);
    }

    public void createIfNotExists(String topicName, TopicSettings settings, Map<String, String> config) {
        if (this.exists(topicName)) {
            log.info("Topic {} already exists, no need to create.", (Object)topicName);
        } else {
            this.createTopic(topicName, settings, config);
        }
    }

    public void deleteTopic(String topicName) {
        log.info("Deleting topic '{}'", (Object)topicName);
        try {
            this.adminClient.deleteTopics(List.of(topicName)).all().get(this.timeout.toSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new KafkaAdminException("Failed to delete topic " + topicName, ex);
        }
        catch (ExecutionException | TimeoutException ex) {
            throw new KafkaAdminException("Failed to delete topic " + topicName, ex);
        }
    }

    public TopicSettings describe(String topicName) {
        try {
            Map kafkaTopicMap = this.adminClient.describeTopics(List.of(topicName)).values();
            TopicDescription description = (TopicDescription)((KafkaFuture)kafkaTopicMap.get(topicName)).get(this.timeout.toSeconds(), TimeUnit.SECONDS);
            List partitions = description.partitions();
            int replicationFactor = partitions.stream().findFirst().map(TopicPartitionInfo::replicas).map(List::size).orElseThrow(() -> new IllegalStateException("Topic " + topicName + " has no partitions"));
            return TopicSettings.builder().replicationFactor((short)replicationFactor).partitions(partitions.size()).build();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KafkaAdminException("Failed to retrieve description of topic " + topicName, e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new KafkaAdminException("Failed to retrieve description of topic " + topicName, e);
        }
    }

    @Override
    public void close() {
        this.adminClient.close();
    }

    public boolean exists(String topicName) {
        try {
            Map kafkaTopicMap = this.adminClient.describeTopics(List.of(topicName)).values();
            ((KafkaFuture)kafkaTopicMap.get(topicName)).get(this.timeout.toSeconds(), TimeUnit.SECONDS);
            return true;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
            throw new KafkaAdminException("Failed to check if Kafka topic " + topicName + " exists", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KafkaAdminException("Failed to check if Kafka topic " + topicName + " exists", e);
        }
        catch (TimeoutException e) {
            throw new KafkaAdminException("Failed to check if Kafka topic " + topicName + " exists", e);
        }
    }

    public void createTopic(String topicName, TopicSettings settings, Map<String, String> config) {
        try {
            NewTopic newTopic = new NewTopic(topicName, settings.getPartitions(), settings.getReplicationFactor());
            this.adminClient.createTopics(List.of(newTopic.configs(config))).all().get(this.timeout.toSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new KafkaAdminException("Failed to create topic " + topicName, ex);
        }
        catch (ExecutionException | TimeoutException ex) {
            throw new KafkaAdminException("Failed to create topic " + topicName, ex);
        }
    }

    public Collection<String> listTopics() {
        try {
            return (Collection)this.adminClient.listTopics().names().get(this.timeout.toSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new KafkaAdminException("Failed to list topics", ex);
        }
        catch (ExecutionException | TimeoutException ex) {
            throw new KafkaAdminException("Failed to list topics", ex);
        }
    }

    public void deleteTopicIfExists(String topic) {
        if (this.exists(topic)) {
            this.deleteTopic(topic);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TopicClient(@NonNull AdminClient adminClient, @NonNull Duration timeout) {
        if (adminClient == null) {
            throw new NullPointerException("adminClient is marked non-null but is null");
        }
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
        this.adminClient = adminClient;
        this.timeout = timeout;
    }
}

