/*
 * Decompiled with CFR 0.152.
 */
package com.bakgethwa.philosopher;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import com.bakgethwa.philosopher.R;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import org.json.JSONException;
import org.json.JSONObject;

public class AdView
extends LinearLayout {
    TextView txtTitle;
    TextView txtAppTitle;
    TextView txtAppDetails;
    Button btnAction;
    Button btnAppAction;
    ImageView imageView;
    CardView basic_layout;
    CardView app_layout;
    URL ImageUrl = null;
    InputStream imgis = null;
    InputStream is = null;
    FileOutputStream mFileOutputStream = null;
    Bitmap bmImg = null;
    int mType = 0;
    String mName = "";
    String mSummary = "";
    String mImage = "";
    String mUrl = "";
    String mActionName = "";
    String mActionPackageName = "";
    Context context;
    String mPackageName;
    String mImageFilePath;
    SharedPreferences sharedpreferences;
    String mUniueID = "";

    public AdView(Context context) {
        super(context);
        this.initialize(context);
    }

    public AdView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    private void initialize(Context context) {
        AdView.inflate((Context)context, (int)R.layout.adview_layout, (ViewGroup)this);
        this.context = context;
        this.mPackageName = context.getPackageName();
        this.txtTitle = (TextView)this.findViewById(R.id.txtTitle);
        this.txtAppTitle = (TextView)this.findViewById(R.id.txtAppTitle);
        this.txtAppDetails = (TextView)this.findViewById(R.id.txtAppDetails);
        this.btnAction = (Button)this.findViewById(R.id.btnAction);
        this.btnAppAction = (Button)this.findViewById(R.id.btnAppAction);
        this.imageView = (ImageView)this.findViewById(R.id.imageView);
        this.basic_layout = (CardView)this.findViewById(R.id.basic_layout);
        this.app_layout = (CardView)this.findViewById(R.id.app_layout);
        this.sharedpreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.mUniueID = this.sharedpreferences.getString("_philosopher_id", "");
        String hash = this.getHash("5c4ffe74809349878efb41c19b0ec6d5" + this.mPackageName);
        new AsyncTaskAd().execute(new String[]{"https://philosopher.today/1.0/getad.php?os=android&origin_name=" + this.mPackageName + "&uid=" + this.mUniueID + "&hash=" + hash});
    }

    public String getHash(String msg) {
        String res = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(msg.getBytes());
            byte[] byteData = digest.digest();
            res = this.bin2hex(byteData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    private String bin2hex(byte[] data) {
        StringBuilder hex = new StringBuilder(data.length * 2);
        for (byte b : data) {
            hex.append(String.format("%02x", b & 0xFF));
        }
        return hex.toString();
    }

    private class AsyncTaskImage
    extends AsyncTask<String, String, Bitmap> {
        private AsyncTaskImage() {
        }

        protected Bitmap doInBackground(String ... strings) {
            block7: {
                try {
                    AdView.this.ImageUrl = new URL(strings[0]);
                    HttpURLConnection conn = (HttpURLConnection)AdView.this.ImageUrl.openConnection();
                    conn.setDoInput(true);
                    conn.connect();
                    AdView.this.imgis = conn.getInputStream();
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inPreferredConfig = Bitmap.Config.RGB_565;
                    AdView.this.bmImg = BitmapFactory.decodeStream((InputStream)AdView.this.imgis, null, (BitmapFactory.Options)options);
                    File file = new File(AdView.this.mImageFilePath);
                    AdView.this.mFileOutputStream = new FileOutputStream(file);
                    AdView.this.bmImg.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)AdView.this.mFileOutputStream);
                    AdView.this.mFileOutputStream.flush();
                    AdView.this.mFileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (AdView.this.imgis != null) {
                        try {
                            AdView.this.imgis.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (AdView.this.mFileOutputStream == null) break block7;
                    try {
                        AdView.this.mFileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return AdView.this.bmImg;
        }

        protected void onPostExecute(Bitmap bitmap) {
            super.onPostExecute((Object)bitmap);
            AdView.this.imageView.setImageBitmap(bitmap);
        }
    }

    private class AsyncTaskAd
    extends AsyncTask<String, String, String> {
        private AsyncTaskAd() {
        }

        protected String doInBackground(String ... strings) {
            String res = null;
            try {
                String output;
                URL apiurl = new URL(strings[0]);
                HttpURLConnection conn = (HttpURLConnection)apiurl.openConnection();
                conn.setDoInput(true);
                conn.connect();
                BufferedReader br = null;
                br = 100 <= conn.getResponseCode() && conn.getResponseCode() <= 399 ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                StringBuilder sb = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    sb.append(output);
                }
                res = sb.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return res;
        }

        protected void onPostExecute(String obj) {
            block9: {
                super.onPostExecute((Object)obj);
                try {
                    block10: {
                        JSONObject jo = new JSONObject(obj);
                        if (jo.getInt("code") != 200) break block9;
                        AdView.this.mType = jo.getInt("type");
                        AdView.this.mName = jo.getString("name");
                        AdView.this.mSummary = jo.getString("summary");
                        AdView.this.mImage = jo.getString("image");
                        AdView.this.mUrl = jo.getString("url");
                        AdView.this.mActionName = jo.getString("action_name");
                        AdView.this.mActionPackageName = jo.getString("package_name");
                        AdView.this.mUniueID = jo.getString("uid");
                        SharedPreferences.Editor sharededitor = AdView.this.sharedpreferences.edit();
                        sharededitor.putString("_philosopher_id", AdView.this.mUniueID);
                        sharededitor.commit();
                        if (AdView.this.mType == 1) {
                            AdView.this.basic_layout.setVisibility(0);
                            AdView.this.app_layout.setVisibility(8);
                            AdView.this.txtTitle.setText((CharSequence)AdView.this.mName);
                            AdView.this.btnAction.setText((CharSequence)AdView.this.mActionName);
                        }
                        if (AdView.this.mType != 2 && AdView.this.mType != 3) break block9;
                        AdView.this.basic_layout.setVisibility(8);
                        AdView.this.app_layout.setVisibility(0);
                        AdView.this.txtAppTitle.setText((CharSequence)AdView.this.mName);
                        AdView.this.txtAppDetails.setText((CharSequence)AdView.this.mSummary);
                        AdView.this.btnAppAction.setText((CharSequence)AdView.this.mActionName);
                        File folder = new File(AdView.this.context.getCacheDir() + "/philosopher");
                        if (!folder.exists()) {
                            folder.mkdir();
                        }
                        AdView.this.mImageFilePath = AdView.this.context.getCacheDir() + "/philosopher/" + AdView.this.mActionPackageName + ".tmp";
                        File imagefile = new File(AdView.this.mImageFilePath);
                        if (imagefile.exists()) {
                            try {
                                Bitmap bitmap = BitmapFactory.decodeFile((String)imagefile.getAbsolutePath());
                                if (bitmap != null) {
                                    AdView.this.imageView.setImageBitmap(bitmap);
                                    break block10;
                                }
                                AdView.this.imageView.setImageDrawable(AdView.this.getResources().getDrawable(R.drawable.poster_sqaure));
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        } else {
                            new AsyncTaskImage().execute(new String[]{AdView.this.mImage});
                            AdView.this.imageView.setImageDrawable(AdView.this.getResources().getDrawable(R.drawable.poster_sqaure));
                        }
                    }
                    AdView.this.btnAppAction.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            String hash = AdView.this.getHash("5c4ffe74809349878efb41c19b0ec6d5" + AdView.this.mUniueID);
                            new AsyncTaskClicked().execute(new String[]{"https://philosopher.today/1.0/clicked.php?os=android&uid=" + AdView.this.mUniueID + "&origin_name=" + AdView.this.mPackageName + "&package_name=" + AdView.this.mActionPackageName + "&type=" + AdView.this.mType + "&hash=" + hash});
                            if (AdView.this.mType == 2) {
                                try {
                                    AdView.this.getContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + AdView.this.mActionPackageName))));
                                }
                                catch (ActivityNotFoundException anfe) {
                                    AdView.this.getContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + AdView.this.mActionPackageName))));
                                }
                            }
                            if (AdView.this.mType == 3) {
                                AdView.this.getContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)AdView.this.mUrl)));
                            }
                        }
                    });
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class AsyncTaskClicked
    extends AsyncTask<String, String, String> {
        private AsyncTaskClicked() {
        }

        protected String doInBackground(String ... strings) {
            String res = null;
            try {
                String output;
                URL apiurl = new URL(strings[0]);
                HttpURLConnection conn = (HttpURLConnection)apiurl.openConnection();
                conn.setDoInput(true);
                conn.connect();
                BufferedReader br = null;
                br = 100 <= conn.getResponseCode() && conn.getResponseCode() <= 399 ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                StringBuilder sb = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    sb.append(output);
                }
                res = sb.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return res;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void onPostExecute(String obj) {
            super.onPostExecute((Object)obj);
            try {
                JSONObject jo = new JSONObject(obj);
                if (jo.getInt("code") != 200) return;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

