/*
 * Decompiled with CFR 0.152.
 */
package com.balysv.material.drawable.menu;

import android.os.Bundle;
import android.view.animation.Interpolator;
import com.balysv.material.drawable.menu.MaterialMenu;
import com.balysv.material.drawable.menu.MaterialMenuDrawable;

public abstract class MaterialMenuBase
implements MaterialMenu {
    private static final String STATE_KEY = "material_menu_icon_state";
    protected MaterialMenuDrawable.IconState currentState = MaterialMenuDrawable.IconState.BURGER;

    @Override
    public final void setState(MaterialMenuDrawable.IconState state) {
        this.currentState = state;
        this.getDrawable().setIconState(state);
    }

    @Override
    public final void animateState(MaterialMenuDrawable.IconState state) {
        this.currentState = state;
        this.getDrawable().animateIconState(state, false);
    }

    @Override
    public final void animatePressedState(MaterialMenuDrawable.IconState state) {
        this.currentState = state;
        this.getDrawable().animateIconState(state, true);
    }

    @Override
    public final void setColor(int color) {
        this.getDrawable().setColor(color);
    }

    @Override
    public final void setTransformationDuration(int duration) {
        this.getDrawable().setTransformationDuration(duration);
    }

    @Override
    public final void setPressedDuration(int duration) {
        this.getDrawable().setPressedDuration(duration);
    }

    @Override
    public final void setInterpolator(Interpolator interpolator) {
        this.getDrawable().setInterpolator(interpolator);
    }

    @Override
    public abstract MaterialMenuDrawable getDrawable();

    public final void setNeverDrawTouch(boolean neverDrawTouch) {
        this.getDrawable().setNeverDrawTouch(neverDrawTouch);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putString(STATE_KEY, this.currentState.name());
    }

    public void syncState(Bundle state) {
        if (state != null) {
            String iconStateName = state.getString(STATE_KEY, MaterialMenuDrawable.IconState.BURGER.name());
            this.setState(MaterialMenuDrawable.IconState.valueOf(iconStateName));
        }
    }
}

