/*
 * Decompiled with CFR 0.152.
 */
package com.balysv.material.drawable.menu;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.Property;
import android.util.TypedValue;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;

public class MaterialMenuDrawable
extends Drawable
implements Animatable {
    public static final int DEFAULT_COLOR = -1;
    public static final int DEFAULT_SCALE = 1;
    public static final int DEFAULT_TRANSFORM_DURATION = 800;
    public static final int DEFAULT_PRESSED_DURATION = 400;
    private static final int BASE_DRAWABLE_WIDTH = 40;
    private static final int BASE_DRAWABLE_HEIGHT = 40;
    private static final int BASE_ICON_WIDTH = 20;
    private static final int BASE_CIRCLE_RADIUS = 18;
    private static final int BASE_GRID_OFFSET = 6;
    private static final float ARROW_MID_LINE_ANGLE = 180.0f;
    private static final float ARROW_TOP_LINE_ANGLE = 135.0f;
    private static final float ARROW_BOT_LINE_ANGLE = 225.0f;
    private static final float X_TOP_LINE_ANGLE = 44.0f;
    private static final float X_BOT_LINE_ANGLE = -44.0f;
    private static final float X_ROTATION_ANGLE = 90.0f;
    private static final float CHECK_MIDDLE_ANGLE = 135.0f;
    private static final float CHECK_BOTTOM_ANGLE = -90.0f;
    private static final float TRANSFORMATION_START = 0.0f;
    private static final float TRANSFORMATION_MID = 1.0f;
    private static final float TRANSFORMATION_END = 2.0f;
    private static final int DEFAULT_CIRCLE_ALPHA = 200;
    private final float dip1;
    private final float dip2;
    private final float dip3;
    private final float dip4;
    private final float dip5;
    private final float dip6;
    private final int width;
    private final int height;
    private final float strokeWidth;
    private final float iconWidth;
    private final float topPadding;
    private final float sidePadding;
    private final float circleRadius;
    private final float gridOffset;
    private final Paint gridPaint;
    private final Paint iconPaint;
    private final Paint circlePaint;
    private float transformationValue = 0.0f;
    private float pressedProgressValue = 0.0f;
    private boolean transformationRunning = false;
    private boolean drawGrid = false;
    private IconState currentIconState = IconState.BURGER;
    private AnimationState animationState = AnimationState.BURGER_ARROW;
    private IconState animatingIconState;
    private boolean drawTouchCircle;
    private boolean neverDrawTouch;
    private ObjectAnimator transformation;
    private ObjectAnimator pressedCircle;
    private Property<MaterialMenuDrawable, Float> transformationProperty = new Property<MaterialMenuDrawable, Float>(Float.class, "transformation"){

        public Float get(MaterialMenuDrawable object) {
            return object.getTransformationValue();
        }

        public void set(MaterialMenuDrawable object, Float value) {
            object.setTransformationValue(value);
        }
    };
    private Property<MaterialMenuDrawable, Float> pressedProgressProperty = new Property<MaterialMenuDrawable, Float>(Float.class, "pressedProgress"){

        public Float get(MaterialMenuDrawable object) {
            return object.getPressedProgress();
        }

        public void set(MaterialMenuDrawable object, Float value) {
            object.setPressedProgress(value);
        }
    };

    public MaterialMenuDrawable(Context context, int color, int scale, int transformDuration, int pressedDuration) {
        Resources resources = context.getResources();
        this.dip1 = MaterialMenuDrawable.dpToPx(resources, 1.0f) * (float)scale;
        this.dip2 = MaterialMenuDrawable.dpToPx(resources, 2.0f) * (float)scale;
        this.dip3 = MaterialMenuDrawable.dpToPx(resources, 3.0f) * (float)scale;
        this.dip4 = MaterialMenuDrawable.dpToPx(resources, 4.0f) * (float)scale;
        this.dip5 = MaterialMenuDrawable.dpToPx(resources, 5.0f) * (float)scale;
        this.dip6 = MaterialMenuDrawable.dpToPx(resources, 6.0f) * (float)scale;
        this.strokeWidth = this.dip3;
        this.width = (int)(MaterialMenuDrawable.dpToPx(resources, 40.0f) * (float)scale);
        this.height = (int)(MaterialMenuDrawable.dpToPx(resources, 40.0f) * (float)scale);
        this.iconWidth = MaterialMenuDrawable.dpToPx(resources, 20.0f) * (float)scale;
        this.circleRadius = MaterialMenuDrawable.dpToPx(resources, 18.0f) * (float)scale;
        this.sidePadding = ((float)this.width - this.iconWidth) / 2.0f;
        this.topPadding = ((float)this.height - 5.0f * this.strokeWidth) / 2.0f;
        this.gridOffset = MaterialMenuDrawable.dpToPx(resources, 6.0f) * (float)scale;
        this.gridPaint = new Paint();
        this.gridPaint.setAntiAlias(false);
        this.gridPaint.setColor(-16711936);
        this.gridPaint.setStrokeWidth(1.0f);
        this.iconPaint = new Paint();
        this.iconPaint.setAntiAlias(true);
        this.iconPaint.setStyle(Paint.Style.STROKE);
        this.iconPaint.setStrokeWidth(this.strokeWidth);
        this.iconPaint.setColor(color);
        this.circlePaint = new Paint();
        this.circlePaint.setAntiAlias(true);
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.circlePaint.setColor(color);
        this.circlePaint.setAlpha(200);
        this.setBounds(0, 0, this.width, this.height);
        this.initAnimations(transformDuration, pressedDuration);
    }

    public void draw(Canvas canvas) {
        if (this.drawGrid) {
            this.drawGrid(canvas);
        }
        float ratio = this.transformationValue <= 1.0f ? this.transformationValue : 2.0f - this.transformationValue;
        this.drawTopLine(canvas, ratio);
        this.drawMiddleLine(canvas, ratio);
        this.drawBottomLine(canvas, ratio);
        if (this.drawTouchCircle) {
            this.drawTouchCircle(canvas);
        }
    }

    private void drawTouchCircle(Canvas canvas) {
        canvas.restore();
        canvas.drawCircle((float)(this.width / 2), (float)(this.height / 2), this.pressedProgressValue, this.circlePaint);
    }

    private void drawMiddleLine(Canvas canvas, float ratio) {
        canvas.restore();
        canvas.save();
        float rotation = 0.0f;
        float pivotX = this.width / 2;
        float pivotY = this.width / 2;
        float startX = this.sidePadding;
        float startY = this.topPadding + this.strokeWidth / 2.0f * 5.0f;
        float stopX = (float)this.width - this.sidePadding;
        float stopY = this.topPadding + this.strokeWidth / 2.0f * 5.0f;
        int alpha = 255;
        switch (this.animationState) {
            case BURGER_ARROW: {
                rotation = this.isMorphingForward() ? ratio * 180.0f : 180.0f + (1.0f - ratio) * 180.0f;
                stopX -= ratio * this.strokeWidth / 2.0f;
                break;
            }
            case BURGER_X: {
                alpha = (int)((1.0f - ratio) * 255.0f);
                break;
            }
            case ARROW_X: {
                alpha = (int)((1.0f - ratio) * 255.0f);
                startX += (1.0f - ratio) * this.strokeWidth / 2.0f;
                break;
            }
            case ARROW_CHECK: {
                if (this.isMorphingForward()) {
                    rotation = ratio * 135.0f;
                    startX += this.strokeWidth / 2.0f + ratio * this.dip4;
                    stopX += ratio * (this.dip6 + this.dip2);
                } else {
                    rotation = 135.0f + (1.0f - ratio) * 45.0f;
                    startX += this.strokeWidth / 2.0f + this.dip4 + (1.0f - ratio) * (this.strokeWidth / 2.0f + this.dip5);
                    stopX += this.dip6 + this.dip2 + (1.0f - ratio) * this.dip2;
                }
                pivotX = (float)(this.width / 2) + this.strokeWidth * 2.0f;
                break;
            }
            case BURGER_CHECK: {
                rotation = ratio * 135.0f;
                startX += ratio * (this.dip4 + this.strokeWidth / 2.0f);
                stopX += ratio * (this.dip6 + this.dip2);
                pivotX = (float)(this.width / 2) + this.strokeWidth * 2.0f;
                break;
            }
            case X_CHECK: {
                alpha = (int)(ratio * 255.0f);
                rotation = ratio * 135.0f;
                startX += ratio * (this.dip4 + this.strokeWidth / 2.0f);
                stopX += ratio * (this.dip6 + this.dip2);
                pivotX = (float)(this.width / 2) + this.strokeWidth * 2.0f;
            }
        }
        this.iconPaint.setAlpha(alpha);
        canvas.rotate(rotation, pivotX, pivotY);
        canvas.drawLine(startX, startY, stopX, stopY, this.iconPaint);
        this.iconPaint.setAlpha(255);
    }

    private void drawTopLine(Canvas canvas, float ratio) {
        canvas.save();
        float rotation = 0.0f;
        float pivotX = 0.0f;
        float pivotY = 0.0f;
        float rotation2 = 0.0f;
        float pivotX2 = (float)(this.width / 2) + this.strokeWidth / 2.0f;
        float pivotY2 = this.topPadding + this.dip2;
        float startX = this.sidePadding;
        float startY = this.topPadding + this.dip2;
        float stopX = (float)this.width - this.sidePadding;
        float stopY = this.topPadding + this.dip2;
        int alpha = 255;
        switch (this.animationState) {
            case BURGER_ARROW: {
                rotation = this.isMorphingForward() ? ratio * 225.0f : 225.0f + (1.0f - ratio) * 135.0f;
                pivotX = this.width / 2;
                pivotY = this.height / 2;
                startX += this.dip3 * ratio;
                stopX -= this.dip3 * ratio;
                break;
            }
            case BURGER_X: {
                rotation = 44.0f * ratio;
                rotation2 = 90.0f * ratio;
                pivotX = this.sidePadding + this.dip4;
                pivotY = this.topPadding + this.dip3;
                stopX += this.dip3 * ratio;
                break;
            }
            case ARROW_X: {
                rotation = 225.0f + -181.0f * ratio;
                rotation2 = 90.0f * ratio;
                pivotX = (float)(this.width / 2) + (this.sidePadding + this.dip4 - (float)(this.width / 2)) * ratio;
                pivotY = (float)(this.height / 2) + (this.topPadding + this.dip3 - (float)(this.height / 2)) * ratio;
                startX += this.dip3 * (1.0f - ratio);
                stopX -= this.dip3 - this.dip6 * ratio;
                break;
            }
            case ARROW_CHECK: {
                alpha = (int)((1.0f - ratio) * 255.0f);
                rotation = 225.0f;
                pivotX = this.width / 2;
                pivotY = this.height / 2;
                startX += this.dip3;
                stopX -= this.dip3;
                break;
            }
            case BURGER_CHECK: {
                alpha = (int)((1.0f - ratio) * 255.0f);
                break;
            }
            case X_CHECK: {
                rotation = 44.0f;
                rotation2 = 90.0f;
                pivotX = this.sidePadding + this.dip4;
                pivotY = this.topPadding + this.dip3;
                stopX += this.dip3;
                alpha = (int)((1.0f - ratio) * 255.0f);
            }
        }
        this.iconPaint.setAlpha(alpha);
        canvas.rotate(rotation, pivotX, pivotY);
        canvas.rotate(rotation2, pivotX2, pivotY2);
        canvas.drawLine(startX, startY, stopX, stopY, this.iconPaint);
        this.iconPaint.setAlpha(255);
    }

    private void drawBottomLine(Canvas canvas, float ratio) {
        canvas.restore();
        canvas.save();
        float rotation = 0.0f;
        float pivotX = 0.0f;
        float pivotY = 0.0f;
        float rotation2 = 0.0f;
        float pivotX2 = (float)(this.width / 2) + this.strokeWidth / 2.0f;
        float pivotY2 = (float)this.height - this.topPadding - this.dip2;
        float startX = this.sidePadding;
        float startY = (float)this.height - this.topPadding - this.dip2;
        float stopX = (float)this.width - this.sidePadding;
        float stopY = (float)this.height - this.topPadding - this.dip2;
        switch (this.animationState) {
            case BURGER_ARROW: {
                rotation = this.isMorphingForward() ? 135.0f * ratio : 135.0f + (1.0f - ratio) * 225.0f;
                pivotX = this.width / 2;
                pivotY = this.height / 2;
                startX = this.sidePadding + this.dip3 * ratio;
                stopX = (float)this.width - this.sidePadding - this.dip3 * ratio;
                break;
            }
            case BURGER_X: {
                rotation2 = this.isMorphingForward() ? -90.0f * ratio : 90.0f * ratio;
                rotation = -44.0f * ratio;
                pivotX = this.sidePadding + this.dip4;
                pivotY = (float)this.height - this.topPadding - this.dip3;
                stopX += this.dip3 * ratio;
                break;
            }
            case ARROW_X: {
                rotation = 135.0f + 181.0f * ratio;
                rotation2 = -90.0f * ratio;
                pivotX = (float)(this.width / 2) + (this.sidePadding + this.dip4 - (float)(this.width / 2)) * ratio;
                pivotY = (float)(this.height / 2) + ((float)(this.height / 2) - this.topPadding - this.dip3) * ratio;
                startX += this.dip3 * (1.0f - ratio);
                stopX -= this.dip3 - this.dip6 * ratio;
                break;
            }
            case ARROW_CHECK: {
                rotation = 135.0f + ratio * -90.0f;
                pivotX = (float)(this.width / 2) - this.strokeWidth * ratio;
                pivotY = (float)(this.height / 2) - this.strokeWidth * ratio;
                startX += this.dip3;
                stopX -= this.dip3;
                break;
            }
            case BURGER_CHECK: {
                rotation = ratio * 45.0f;
                pivotX = (float)(this.width / 2) - this.strokeWidth * ratio;
                pivotY = (float)(this.height / 2) - this.strokeWidth * ratio;
                startX += this.dip3 * ratio;
                stopX -= this.dip3 * ratio;
                break;
            }
            case X_CHECK: {
                rotation2 = -90.0f * (1.0f - ratio);
                rotation = -44.0f + 89.0f * ratio;
                pivotX = this.sidePadding + this.dip4 + ((float)(this.width / 2) - this.strokeWidth - this.sidePadding - this.dip4) * ratio;
                pivotY = (float)this.height - this.topPadding - this.dip3 + (this.topPadding + this.dip3 + (float)(this.height / 2) - this.strokeWidth - (float)this.height) * ratio;
                startX += this.dip3 - this.dip3 * (1.0f - ratio);
                stopX -= this.dip3 - this.dip6 * (1.0f - ratio);
            }
        }
        canvas.rotate(rotation, pivotX, pivotY);
        canvas.rotate(rotation2, pivotX2, pivotY2);
        canvas.drawLine(startX, startY, stopX, stopY, this.iconPaint);
    }

    private void drawGrid(Canvas canvas) {
        int i = 0;
        while (i < this.width + 1) {
            if ((float)i % this.sidePadding == 0.0f) {
                this.gridPaint.setColor(-16776961);
            }
            canvas.drawLine((float)i, 0.0f, (float)i, (float)this.height, this.gridPaint);
            if ((float)i % this.sidePadding == 0.0f) {
                this.gridPaint.setColor(-16711936);
            }
            i = (int)((float)i + this.dip1);
        }
        i = 0;
        while (i < this.height + 1) {
            if ((float)i % this.gridOffset == 0.0f) {
                this.gridPaint.setColor(-16776961);
            }
            canvas.drawLine(0.0f, (float)i, (float)this.width, (float)i, this.gridPaint);
            if ((float)i % this.gridOffset == 0.0f) {
                this.gridPaint.setColor(-16711936);
            }
            i = (int)((float)i + this.dip1);
        }
    }

    private boolean isMorphingForward() {
        return this.transformationValue <= 1.0f;
    }

    public void setAlpha(int alpha) {
        this.iconPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.iconPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -2;
    }

    public void setColor(int color) {
        this.iconPaint.setColor(color);
        this.circlePaint.setColor(color);
        this.invalidateSelf();
    }

    protected void setDrawGrid(boolean drawGrid) {
        this.drawGrid = drawGrid;
    }

    public void setTransformationDuration(int duration) {
        this.transformation.setDuration((long)duration);
    }

    public void setPressedDuration(int duration) {
        this.pressedCircle.setDuration((long)duration);
    }

    public void setInterpolator(Interpolator interpolator) {
        this.transformation.setInterpolator((TimeInterpolator)interpolator);
    }

    public void setNeverDrawTouch(boolean neverDrawTouch) {
        this.neverDrawTouch = neverDrawTouch;
    }

    public synchronized void setIconState(IconState iconState) {
        if (this.currentIconState == iconState) {
            return;
        }
        switch (iconState) {
            case BURGER: {
                this.animationState = AnimationState.BURGER_ARROW;
                this.transformationValue = 0.0f;
                break;
            }
            case ARROW: {
                this.animationState = AnimationState.BURGER_ARROW;
                this.transformationValue = 1.0f;
                break;
            }
            case X: {
                this.animationState = AnimationState.BURGER_X;
                this.transformationValue = 1.0f;
                break;
            }
            case CHECK: {
                this.animationState = AnimationState.BURGER_CHECK;
                this.transformationValue = 1.0f;
            }
        }
        this.currentIconState = iconState;
        this.invalidateSelf();
    }

    public synchronized void animateIconState(IconState state, boolean drawTouch) {
        if (!this.transformationRunning) {
            this.drawTouchCircle = drawTouch;
            this.animatingIconState = state;
            this.start();
        }
    }

    public Float getTransformationValue() {
        return Float.valueOf(this.transformationValue);
    }

    public void setTransformationValue(Float value) {
        this.transformationValue = value.floatValue();
        this.invalidateSelf();
    }

    public Float getPressedProgress() {
        return Float.valueOf(this.pressedProgressValue);
    }

    public void setPressedProgress(Float value) {
        this.pressedProgressValue = value.floatValue();
        this.circlePaint.setAlpha((int)(200.0f * (1.0f - value.floatValue() / (this.circleRadius * 1.22f))));
        this.invalidateSelf();
    }

    private void initAnimations(int transformDuration, int pressedDuration) {
        this.transformation = ObjectAnimator.ofFloat((Object)((Object)this), this.transformationProperty, (float[])new float[]{0.0f});
        this.transformation.setInterpolator((TimeInterpolator)new DecelerateInterpolator(3.0f));
        this.transformation.setDuration((long)transformDuration);
        this.transformation.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                MaterialMenuDrawable.this.transformationRunning = false;
                MaterialMenuDrawable.this.setIconState(MaterialMenuDrawable.this.animatingIconState);
            }
        });
        this.pressedCircle = ObjectAnimator.ofFloat((Object)((Object)this), this.pressedProgressProperty, (float[])new float[]{0.0f, 0.0f});
        this.pressedCircle.setDuration((long)pressedDuration);
        this.pressedCircle.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.pressedCircle.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                MaterialMenuDrawable.this.pressedProgressValue = 0.0f;
            }

            @Override
            public void onAnimationCancel(Animator animation) {
                MaterialMenuDrawable.this.pressedProgressValue = 0.0f;
            }
        });
    }

    private boolean resolveTransformation() {
        boolean isAnimatingCheck;
        boolean isCurrentBurger = this.currentIconState == IconState.BURGER;
        boolean isCurrentArrow = this.currentIconState == IconState.ARROW;
        boolean isCurrentX = this.currentIconState == IconState.X;
        boolean isCurrentCheck = this.currentIconState == IconState.CHECK;
        boolean isAnimatingBurger = this.animatingIconState == IconState.BURGER;
        boolean isAnimatingArrow = this.animatingIconState == IconState.ARROW;
        boolean isAnimatingX = this.animatingIconState == IconState.X;
        boolean bl = isAnimatingCheck = this.animatingIconState == IconState.CHECK;
        if (isCurrentBurger && isAnimatingArrow || isCurrentArrow && isAnimatingBurger) {
            this.animationState = AnimationState.BURGER_ARROW;
            return isCurrentBurger;
        }
        if (isCurrentArrow && isAnimatingX || isCurrentX && isAnimatingArrow) {
            this.animationState = AnimationState.ARROW_X;
            return isCurrentArrow;
        }
        if (isCurrentBurger && isAnimatingX || isCurrentX && isAnimatingBurger) {
            this.animationState = AnimationState.BURGER_X;
            return isCurrentBurger;
        }
        if (isCurrentArrow && isAnimatingCheck || isCurrentCheck && isAnimatingArrow) {
            this.animationState = AnimationState.ARROW_CHECK;
            return isCurrentArrow;
        }
        if (isCurrentBurger && isAnimatingCheck || isCurrentCheck && isAnimatingBurger) {
            this.animationState = AnimationState.BURGER_CHECK;
            return isCurrentBurger;
        }
        if (isCurrentX && isAnimatingCheck || isCurrentCheck && isAnimatingX) {
            this.animationState = AnimationState.X_CHECK;
            return isCurrentX;
        }
        throw new IllegalStateException(String.format("Animating from %s to %s is not supported", new Object[]{this.currentIconState, this.animatingIconState}));
    }

    public void start() {
        if (this.transformationRunning || this.animatingIconState == null || this.animatingIconState == this.currentIconState) {
            return;
        }
        this.transformationRunning = true;
        boolean direction = this.resolveTransformation();
        this.transformation.setFloatValues(new float[]{direction ? 0.0f : 1.0f, direction ? 1.0f : 2.0f});
        this.transformation.start();
        if (this.pressedCircle.isRunning()) {
            this.pressedCircle.cancel();
        }
        if (this.drawTouchCircle && !this.neverDrawTouch) {
            this.pressedCircle.setFloatValues(new float[]{this.pressedProgressValue, this.circleRadius * 1.22f});
            this.pressedCircle.start();
        }
        this.invalidateSelf();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        if (this.transformation.isRunning()) {
            this.transformation.end();
        } else {
            this.transformationRunning = false;
            this.invalidateSelf();
        }
    }

    public boolean isRunning() {
        return this.transformationRunning;
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    static float dpToPx(Resources resources, float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    private class SimpleAnimatorListener
    implements Animator.AnimatorListener {
        private SimpleAnimatorListener() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    private static enum AnimationState {
        BURGER_ARROW,
        BURGER_X,
        ARROW_X,
        ARROW_CHECK,
        BURGER_CHECK,
        X_CHECK;

    }

    public static enum IconState {
        BURGER,
        ARROW,
        X,
        CHECK;

    }
}

