/*
 * Decompiled with CFR 0.152.
 */
package com.balysv.material.drawable.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import com.balysv.material.drawable.menu.MaterialMenu;
import com.balysv.material.drawable.menu.MaterialMenuDrawable;
import com.balysv.material.drawable.menu.R;

public class MaterialMenuView
extends View
implements MaterialMenu {
    private MaterialMenuDrawable drawable;
    private MaterialMenuDrawable.IconState currentState = MaterialMenuDrawable.IconState.BURGER;
    private int color;
    private int scale;
    private int transformDuration;
    private int pressedDuration;

    public MaterialMenuView(Context context) {
        this(context, null);
    }

    public MaterialMenuView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialMenuView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttributes(context, attrs);
        this.drawable = new MaterialMenuDrawable(context, this.color, this.scale, this.transformDuration, this.pressedDuration);
        this.drawable.setCallback((Drawable.Callback)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes(Context context, AttributeSet attributeSet) {
        TypedArray attr = this.getTypedArray(context, attributeSet, R.styleable.MaterialMenuView);
        if (attr == null) {
            return;
        }
        try {
            this.color = attr.getColor(0, -1);
            this.scale = attr.getInteger(1, 1);
            this.transformDuration = attr.getInteger(2, 800);
            this.pressedDuration = attr.getInteger(3, 400);
        }
        finally {
            attr.recycle();
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.drawable.draw(canvas);
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.drawable || super.verifyDrawable(who);
    }

    @Override
    public void setState(MaterialMenuDrawable.IconState state) {
        this.currentState = state;
        this.drawable.setIconState(state);
    }

    @Override
    public void animateState(MaterialMenuDrawable.IconState state) {
        this.currentState = state;
        this.drawable.animateIconState(state, false);
    }

    @Override
    public void animatePressedState(MaterialMenuDrawable.IconState state) {
        this.currentState = state;
        this.drawable.animateIconState(state, true);
    }

    @Override
    public void setColor(int color) {
        this.drawable.setColor(color);
    }

    @Override
    public void setTransformationDuration(int duration) {
        this.drawable.setTransformationDuration(duration);
    }

    @Override
    public void setPressedDuration(int duration) {
        this.drawable.setPressedDuration(duration);
    }

    @Override
    public void setInterpolator(Interpolator interpolator) {
        this.drawable.setInterpolator(interpolator);
    }

    @Override
    public MaterialMenuDrawable getDrawable() {
        return this.drawable;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.drawable.getIntrinsicWidth(), (int)0x40000000);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.drawable.getIntrinsicHeight(), (int)0x40000000);
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.state = this.currentState;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setState(savedState.state);
    }

    private TypedArray getTypedArray(Context context, AttributeSet attributeSet, int[] attr) {
        return context.obtainStyledAttributes(attributeSet, attr, 0, 0);
    }

    private static class SavedState
    extends View.BaseSavedState {
        protected MaterialMenuDrawable.IconState state;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.state = MaterialMenuDrawable.IconState.valueOf(in.readString());
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.state.name());
        }
    }
}

