/**
 * Copyright 2013 BancVue, LTD
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.bancvue.gradle.pmd

import org.gradle.api.reporting.ReportContainer
import org.gradle.api.reporting.SingleFileReport

/**
 * The reporting configuration for the {@link Cpd} task.
 */
interface CpdReports extends ReportContainer<SingleFileReport> {

    /**
     * The cpd (single file) HTML report
     *
     * @return The cpd (single file) HTML report
     */
    SingleFileReport getHtml();

    /**
     * The cpd (single file) XML report
     *
     * @return The cpd (single file) XML report
     */
    SingleFileReport getXml();

}
