/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthRestClient;
import com.bandwidth.sdk.model.BaseModelObject;
import com.bandwidth.sdk.model.Event;
import com.bandwidth.sdk.model.Gather;
import com.bandwidth.sdk.model.Gender;
import com.bandwidth.sdk.model.Recording;
import com.bandwidth.sdk.model.SentenceLocale;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Call
extends BaseModelObject {
    public Call(BandwidthRestClient client, String parentUri, JSONObject jsonObject) {
        super(client, parentUri, jsonObject);
    }

    public String getDirection() {
        return this.getPropertyAsString("direction");
    }

    public String getState() {
        return this.getPropertyAsString("state");
    }

    public String getFrom() {
        return this.getPropertyAsString("from");
    }

    public String getTo() {
        return this.getPropertyAsString("to");
    }

    public String getCallbackUrl() {
        return this.getPropertyAsString("callbackUrl");
    }

    public String getEvents() {
        return this.getPropertyAsString("events");
    }

    public Date getStartTime() {
        return this.getPropertyAsDate("startTime");
    }

    public Date getActiveTime() {
        return this.getPropertyAsDate("activeTime");
    }

    public Date getEndTime() {
        return this.getPropertyAsDate("endTime");
    }

    public Long getChargeableDuration() {
        return this.getPropertyAsLong("chargeableDuration");
    }

    public boolean isRecordingEnabled() {
        return this.getPropertyAsBoolean("recordingEnabled");
    }

    public List<Recording> getRecordings() throws IOException {
        String recordingsPath = StringUtils.join((Object[])new String[]{this.getUri(), "recordings"}, (char)'/');
        JSONArray array = this.client.getArray(recordingsPath, null);
        ArrayList<Recording> list = new ArrayList<Recording>();
        for (Object object : array) {
            list.add(new Recording(this.client, recordingsPath, (JSONObject)object));
        }
        return list;
    }

    public List<Event> getEventsList() throws IOException {
        String eventsPath = StringUtils.join((Object[])new String[]{this.getUri(), "events"}, (char)'/');
        JSONArray array = this.client.getArray(eventsPath, null);
        ArrayList<Event> list = new ArrayList<Event>();
        for (Object object : array) {
            list.add(new Event(this.client, eventsPath, (JSONObject)object));
        }
        return list;
    }

    public Event getEvent(String eventId) throws IOException {
        String eventPath = StringUtils.join((Object[])new String[]{this.getUri(), "events", eventId}, (char)'/');
        JSONObject jsonObject = this.client.getObject(eventPath);
        String eventsPath = StringUtils.join((Object[])new String[]{this.getUri(), "events"}, (char)'/');
        return new Event(this.client, eventsPath, jsonObject);
    }

    public void hangUp() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("state", "completed");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = this.client.getObject(uri);
        this.updateProperties(jsonObject);
    }

    public void answerOnIncoming() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("state", "active");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = this.client.getObject(uri);
        this.updateProperties(jsonObject);
    }

    public void rejectIncoming() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("state", "rejected");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = this.client.getObject(uri);
        this.updateProperties(jsonObject);
    }

    public void recordingOn() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("recordingEnabled", "true");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = this.client.getObject(uri);
        this.updateProperties(jsonObject);
    }

    public void recordingOff() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("recordingEnabled", "false");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = this.client.getObject(uri);
        this.updateProperties(jsonObject);
    }

    public CallTransferBuilder callTransferBuilder(String transferTo) {
        return new CallTransferBuilder(transferTo);
    }

    public CallAudioBuilder newAudioBuilder() {
        return new CallAudioBuilder();
    }

    public void stopAudioFilePlaying() throws IOException {
        new CallAudioBuilder().fileUrl("").create();
    }

    public void stopSentence() throws IOException {
        new CallAudioBuilder().sentence("").create();
    }

    public void sendDtmf(String dtmf) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dtmfOut", dtmf);
        String uri = StringUtils.join((Object[])new String[]{this.getUri(), "dtmf"}, (char)'/');
        this.client.post(uri, params);
    }

    public CallGatherBuilder callGatherBuilder() {
        return new CallGatherBuilder();
    }

    public Gather getGather(String gatherId) throws IOException {
        String gatherPath = StringUtils.join((Object[])new String[]{this.getUri(), "gather", gatherId}, (char)'/');
        JSONObject jsonObject = this.client.getObject(gatherPath);
        String gathersPath = StringUtils.join((Object[])new String[]{this.getUri(), "events"}, (char)'/');
        return new Gather(this.client, gathersPath, jsonObject);
    }

    private void createGather(Map<String, Object> params) throws IOException {
        String uri = StringUtils.join((Object[])new String[]{this.getUri(), "gather"}, (char)'/');
        this.client.post(uri, params);
    }

    private void createCallAudio(Map<String, Object> params) throws IOException {
        String audioPath = StringUtils.join((Object[])new String[]{this.getUri(), "audio"}, (char)'/');
        this.client.post(audioPath, params);
    }

    private void transfer(Map<String, Object> params) throws IOException {
        params.put("state", "transferring");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = this.client.getObject(uri);
        this.updateProperties(jsonObject);
    }

    public String toString() {
        return "Call{id='" + this.getId() + '\'' + ", direction=" + this.getDirection() + ", state=" + this.getState() + ", from='" + this.getFrom() + '\'' + ", to='" + this.getTo() + '\'' + ", callbackUrl='" + this.getCallbackUrl() + '\'' + ", events='" + this.getEvents() + '\'' + ", startTime=" + this.getStartTime() + ", activeTime=" + this.getActiveTime() + ", endTime=" + this.getEndTime() + ", chargeableDuration=" + this.getChargeableDuration() + ", recordingEnabled=" + this.isRecordingEnabled() + '}';
    }

    public class CallGatherBuilder {
        private Map<String, Object> params = new HashMap<String, Object>();
        private Map<String, Object> prompt = new HashMap<String, Object>();

        public void create() throws IOException {
            if (!this.prompt.isEmpty()) {
                this.params.put("prompt", this.prompt);
            }
            Call.this.createGather(this.params);
        }

        public CallGatherBuilder maxDigits(int maxDigits) {
            this.params.put("maxDigits", String.valueOf(maxDigits));
            return this;
        }

        public CallGatherBuilder interDigitTimeout(int maxDigits) {
            this.params.put("interDigitTimeout", String.valueOf(maxDigits));
            return this;
        }

        public CallGatherBuilder terminatingDigits(String terminatingDigits) {
            this.params.put("terminatingDigits", terminatingDigits);
            return this;
        }

        public CallGatherBuilder suppressDtmf(boolean suppressDtmf) {
            this.params.put("suppressDtmf", String.valueOf(suppressDtmf));
            return this;
        }

        public CallGatherBuilder tag(String tag) {
            this.params.put("tag", tag);
            return this;
        }

        public CallGatherBuilder promptSentence(String promptSentence) {
            this.prompt.put("sentence", promptSentence);
            return this;
        }

        public CallGatherBuilder promptGender(Gender gender) {
            this.prompt.put("gender", gender.name());
            return this;
        }

        public CallGatherBuilder promptLocale(SentenceLocale locale) {
            this.prompt.put("locale", locale.restValue);
            return this;
        }

        public CallGatherBuilder promptFileUrl(String promptFileUrl) {
            this.prompt.put("fileUrl", promptFileUrl);
            return this;
        }

        public CallGatherBuilder promptLoopEnabled(boolean promptLoopEnabled) {
            this.prompt.put("loopEnabled", String.valueOf(promptLoopEnabled));
            return this;
        }

        public CallGatherBuilder promptBargeable(boolean promptBargeable) {
            this.prompt.put("bargeable", String.valueOf(promptBargeable));
            return this;
        }
    }

    public class CallAudioBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public CallAudioBuilder fileUrl(String fileUrl) {
            this.params.put("fileUrl", fileUrl);
            return this;
        }

        public CallAudioBuilder sentence(String sentence) {
            this.params.put("sentence", sentence);
            return this;
        }

        public CallAudioBuilder gender(Gender gender) {
            this.params.put("gender", gender.name());
            return this;
        }

        public CallAudioBuilder locale(SentenceLocale locale) {
            this.params.put("locale", locale.restValue);
            return this;
        }

        public CallAudioBuilder voice(String voice) {
            this.params.put("voice", voice);
            return this;
        }

        public CallAudioBuilder loopEnabled(boolean loopEnabled) {
            this.params.put("loopEnabled", String.valueOf(loopEnabled));
            return this;
        }

        public void create() throws IOException {
            Call.this.createCallAudio(this.params);
        }
    }

    public class CallTransferBuilder {
        private Map<String, Object> params = new HashMap<String, Object>();
        private Map<String, Object> whisperAudio = new HashMap<String, Object>();

        public CallTransferBuilder(String number) {
            this.params.put("transferTo", number);
        }

        public CallTransferBuilder callbackUrl(String callbackUrl) {
            this.params.put("callbackUrl", callbackUrl);
            return this;
        }

        public CallTransferBuilder transferCallerId(String transferCallerId) {
            this.params.put("transferCallerId", transferCallerId);
            return this;
        }

        public CallTransferBuilder sentence(String sentence) {
            this.whisperAudio.put("sentence", sentence);
            return this;
        }

        public CallTransferBuilder gender(Gender gender) {
            this.whisperAudio.put("gender", gender.name());
            return this;
        }

        public CallTransferBuilder voice(String voice) {
            this.whisperAudio.put("voice", voice);
            return this;
        }

        public CallTransferBuilder locale(SentenceLocale locale) {
            this.whisperAudio.put("locale", (Object)locale);
            return this;
        }

        public void create() throws IOException {
            if (!this.whisperAudio.isEmpty()) {
                this.params.put("whisperAudio", this.whisperAudio);
            }
            Call.this.transfer(this.params);
        }
    }
}

