/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk;

import com.bandwidth.sdk.model.Account;
import com.bandwidth.sdk.model.Applications;
import com.bandwidth.sdk.model.AvailableNumbers;
import com.bandwidth.sdk.model.Bridges;
import com.bandwidth.sdk.model.Calls;
import com.bandwidth.sdk.model.Conferences;
import com.bandwidth.sdk.model.Errors;
import com.bandwidth.sdk.model.Media;
import com.bandwidth.sdk.model.Messages;
import com.bandwidth.sdk.model.NumberInfo;
import com.bandwidth.sdk.model.PhoneNumbers;
import com.bandwidth.sdk.model.Recordings;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class BandwidthRestClient {
    private static final String GET = "get";
    private static final String POST = "post";
    private static final String PUT = "put";
    private static final String DELETE = "delete";
    private final String usersUri;
    private final String token;
    private final String secret;
    private HttpClient httpClient;
    private Account account;
    private Applications applications;
    private AvailableNumbers availableNumbers;
    private Bridges bridges;
    private Calls calls;
    private Conferences conferences;
    private Errors errors;
    private Messages messages;
    private PhoneNumbers phoneNumbers;
    private Recordings recordings;
    private Media media;

    public BandwidthRestClient(String userId, String token, String secret) {
        this.usersUri = String.format("users/%s", userId);
        this.token = token;
        this.secret = secret;
        this.httpClient = new DefaultHttpClient();
    }

    public Account getAccount() {
        if (this.account == null) {
            this.account = new Account(this, this.usersUri);
        }
        return this.account;
    }

    public Applications getApplications() {
        if (this.applications == null) {
            this.applications = new Applications(this, this.usersUri);
        }
        return this.applications;
    }

    public AvailableNumbers getAvailableNumbers() {
        if (this.availableNumbers == null) {
            this.availableNumbers = new AvailableNumbers(this);
        }
        return this.availableNumbers;
    }

    public Bridges getBridges() {
        if (this.bridges == null) {
            this.bridges = new Bridges(this, this.usersUri);
        }
        return this.bridges;
    }

    public Calls getCalls() {
        if (this.calls == null) {
            this.calls = new Calls(this, this.usersUri);
        }
        return this.calls;
    }

    public Conferences getConferences() {
        if (this.conferences == null) {
            this.conferences = new Conferences(this, this.usersUri);
        }
        return this.conferences;
    }

    public Errors getErrors() {
        if (this.errors == null) {
            this.errors = new Errors(this, this.usersUri);
        }
        return this.errors;
    }

    public Messages getMessages() {
        if (this.messages == null) {
            this.messages = new Messages(this, this.usersUri);
        }
        return this.messages;
    }

    public PhoneNumbers getPhoneNumbers() {
        if (this.phoneNumbers == null) {
            this.phoneNumbers = new PhoneNumbers(this, this.usersUri);
        }
        return this.phoneNumbers;
    }

    public Recordings getRecordings() {
        if (this.recordings == null) {
            this.recordings = new Recordings(this, this.usersUri);
        }
        return this.recordings;
    }

    public Media getMedia() {
        if (this.media == null) {
            this.media = new Media(this, this.usersUri);
        }
        return this.media;
    }

    public NumberInfo getNumberInfoByNumber(String number) throws IOException {
        String uri = StringUtils.join((Object[])new String[]{"phoneNumbers", "numberInfo", number}, (char)'/');
        JSONObject object = this.getObject(uri);
        return new NumberInfo(this, uri, object);
    }

    public JSONArray getArray(String uri, Map<String, Object> params) throws IOException {
        String path = this.getPath(uri);
        RestResponse response = this.request(path, GET, params);
        if (response.isError()) {
            throw new IOException(response.getResponseText());
        }
        if (response.isJson()) {
            try {
                return (JSONArray)new JSONParser().parse(response.getResponseText());
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        throw new IOException("Response is not a JSON format.");
    }

    public JSONObject getObject(String uri) throws IOException {
        String path = this.getPath(uri);
        RestResponse response = this.request(path, GET);
        if (response.isError()) {
            throw new IOException(response.getResponseText());
        }
        if (response.isJson()) {
            try {
                return (JSONObject)new JSONParser().parse(response.getResponseText());
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        throw new IOException("Response is not a JSON format.");
    }

    public JSONObject create(String uri, Map<String, Object> params) throws IOException {
        String path = this.getPath(uri);
        RestResponse response = this.request(path, POST, params);
        if (response.isError()) {
            throw new IOException(response.getResponseText());
        }
        String location = response.getLocation();
        if (location != null) {
            response = this.request(location, GET);
            if (response.isError()) {
                throw new IOException(response.getResponseText());
            }
            if (response.isJson()) {
                try {
                    return (JSONObject)new JSONParser().parse(response.getResponseText());
                }
                catch (ParseException e) {
                    throw new IOException(e);
                }
            }
            throw new IOException("Response is not a JSON format.");
        }
        throw new IOException("There is no location of new application.");
    }

    public void post(String uri, Map<String, Object> params) throws IOException {
        String path = this.getPath(uri);
        RestResponse response = this.request(path, POST, params);
        if (response.isError()) {
            throw new IOException(response.getResponseText());
        }
    }

    public void delete(String uri) throws IOException {
        String path = this.getPath(uri);
        RestResponse response = this.request(path, DELETE);
        if (response.isError()) {
            throw new IOException(response.getResponseText());
        }
    }

    public void uploadFile(String uri, File sourceFile, String contentType) throws IOException {
        String path = this.getPath(uri);
        HttpPut request = (HttpPut)this.setupRequest(path, PUT, null);
        request.setEntity((HttpEntity)(contentType == null ? new FileEntity(sourceFile) : new FileEntity(sourceFile, ContentType.parse((String)contentType))));
        this.performRequest((HttpUriRequest)request);
    }

    public void downloadFileTo(String uri, File destFile) throws IOException {
        String path = this.getPath(uri);
        HttpGet request = (HttpGet)this.setupRequest(path, GET, Collections.<String, Object>emptyMap());
        OutputStream outputStream = null;
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            if (statusCode >= 400) {
                throw new IOException(EntityUtils.toString((HttpEntity)entity));
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(destFile));
            entity.writeTo(outputStream);
        }
        catch (ClientProtocolException e1) {
            throw new IOException(e1);
        }
        catch (IOException e1) {
            throw new IOException(e1);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    private String getPath(String uri) {
        Object[] parts = new String[]{"https://api.catapult.inetwork.com", "v1", uri};
        return StringUtils.join((Object[])parts, (char)'/');
    }

    private RestResponse request(String path, String method) throws IOException {
        return this.request(path, method, null);
    }

    private RestResponse request(String path, String method, Map<String, Object> paramList) throws IOException {
        if (paramList == null) {
            paramList = Collections.emptyMap();
        }
        HttpUriRequest request = this.setupRequest(path, method, paramList);
        return this.performRequest(request);
    }

    private RestResponse performRequest(HttpUriRequest request) throws IOException {
        try {
            HttpResponse response = this.httpClient.execute(request);
            HttpEntity entity = response.getEntity();
            String responseBody = "";
            if (entity != null) {
                responseBody = EntityUtils.toString((HttpEntity)entity);
            }
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            RestResponse restResponse = new RestResponse(responseBody, statusCode);
            Header[] headers = response.getHeaders("Content-Type");
            if (headers.length > 0) {
                restResponse.setContentType(headers[0].getValue());
            }
            if ((headers = response.getHeaders("Location")).length > 0) {
                restResponse.setLocation(headers[0].getValue());
            }
            return restResponse;
        }
        catch (ClientProtocolException e1) {
            throw new IOException(e1);
        }
        catch (IOException e1) {
            throw new IOException(e1);
        }
    }

    private HttpUriRequest setupRequest(String path, String method, Map<String, Object> params) {
        HttpUriRequest request = this.buildMethod(method, path, params);
        request.addHeader((Header)new BasicHeader("Accept", "application/json"));
        request.addHeader((Header)new BasicHeader("Accept-Charset", "utf-8"));
        String s = this.token + ":" + this.secret;
        String auth = new String(Base64.encodeBase64((byte[])s.getBytes()));
        request.setHeader((Header)new BasicHeader("Authorization", "Basic " + auth));
        return request;
    }

    private HttpUriRequest buildMethod(String method, String path, Map<String, Object> params) {
        if (StringUtils.equals((CharSequence)method, (CharSequence)GET)) {
            return this.generateGetRequest(path, params);
        }
        if (StringUtils.equals((CharSequence)method, (CharSequence)POST)) {
            return this.generatePostRequest(path, params);
        }
        if (StringUtils.equals((CharSequence)method, (CharSequence)PUT)) {
            return this.generatePutRequest(path, params);
        }
        if (StringUtils.equals((CharSequence)method, (CharSequence)DELETE)) {
            return this.generateDeleteRequest(path);
        }
        throw new RuntimeException("Must not be here.");
    }

    private HttpGet generateGetRequest(String path, Map<String, Object> paramMap) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (String key : paramMap.keySet()) {
            pairs.add((NameValuePair)new BasicNameValuePair(key, paramMap.get(key).toString()));
        }
        URI uri = this.buildUri(path, pairs);
        return new HttpGet(uri);
    }

    private HttpPost generatePostRequest(String path, Map<String, Object> paramMap) {
        URI uri = this.buildUri(path);
        String s = JSONObject.toJSONString(paramMap);
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)new StringEntity(s, ContentType.APPLICATION_JSON));
        return post;
    }

    private HttpPut generatePutRequest(String path, Map<String, Object> paramMap) {
        URI uri = this.buildUri(path);
        HttpPut put = new HttpPut(uri);
        if (paramMap != null) {
            String s = JSONObject.toJSONString(paramMap);
            put.setEntity((HttpEntity)new StringEntity(s, ContentType.APPLICATION_JSON));
        }
        return put;
    }

    private HttpDelete generateDeleteRequest(String path) {
        URI uri = this.buildUri(path);
        return new HttpDelete(uri);
    }

    private URI buildUri(String path) {
        return this.buildUri(path, null);
    }

    private URI buildUri(String path, List<NameValuePair> queryStringParams) {
        URI uri;
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        if (queryStringParams != null && queryStringParams.size() > 0) {
            sb.append("?");
            sb.append(URLEncodedUtils.format(queryStringParams, (String)"UTF-8"));
        }
        try {
            uri = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid uri", e);
        }
        return uri;
    }

    private class RestResponse {
        private String responseText;
        private boolean error;
        private String contentType;
        private String location;

        public RestResponse(String text, int status) {
            this.responseText = text;
            this.error = status >= 400;
        }

        public String getResponseText() {
            return this.responseText;
        }

        public boolean isError() {
            return this.error;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public boolean isJson() {
            return this.contentType.toLowerCase().contains("application/json");
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }
    }
}

