/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthRestClient;
import com.bandwidth.sdk.model.Application;
import com.bandwidth.sdk.model.BaseModelObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Applications
extends BaseModelObject {
    public Applications(BandwidthRestClient client, String parentUri) {
        super(client, parentUri, null);
    }

    public QueryApplicationsBuilder queryApplicationsBuilder() {
        return new QueryApplicationsBuilder();
    }

    public Application getApplication(String id) throws IOException {
        String applicationsUri = this.getUri();
        String uri = StringUtils.join((Object[])new String[]{applicationsUri, id}, (char)'/');
        JSONObject jsonObject = this.client.getObject(uri);
        return new Application(this.client, applicationsUri, jsonObject);
    }

    public NewApplicationBuilder newApplicationBuilder(String name) {
        return new NewApplicationBuilder(name);
    }

    private List<Application> getApplications(Map<String, Object> params) throws IOException {
        String applicationsUri = this.getUri();
        JSONArray array = this.client.getArray(applicationsUri, params);
        ArrayList<Application> applications = new ArrayList<Application>();
        for (Object obj : array) {
            applications.add(new Application(this.client, applicationsUri, (JSONObject)obj));
        }
        return applications;
    }

    @Override
    protected String getUri() {
        return StringUtils.join((Object[])new String[]{this.parentUri, "applications"}, (char)'/');
    }

    private Application createApplication(Map<String, Object> params) throws IOException {
        String applicationsUri = this.getUri();
        JSONObject jsonObject = this.client.create(applicationsUri, params);
        return new Application(this.client, applicationsUri, jsonObject);
    }

    public class NewApplicationBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public NewApplicationBuilder(String name) {
            this.params.put("name", name);
        }

        public NewApplicationBuilder incomingCallUrl(String incomingCallUrl) {
            this.params.put("incomingCallUrl", incomingCallUrl);
            return this;
        }

        public NewApplicationBuilder incomingSmsUrl(String incomingSmsUrl) {
            this.params.put("incomingSmsUrl", incomingSmsUrl);
            return this;
        }

        public NewApplicationBuilder autoAnswer(Boolean autoAnswer) {
            this.params.put("autoAnswer", autoAnswer);
            return this;
        }

        public NewApplicationBuilder incomingCallFallbackUrl(String incomingCallFallbackUrl) {
            this.params.put("incomingCallFallbackUrl", incomingCallFallbackUrl);
            return this;
        }

        public NewApplicationBuilder incomingCallUrlCallbackTimeout(Long incomingCallUrlCallbackTimeout) {
            this.params.put("incomingCallUrlCallbackTimeout", incomingCallUrlCallbackTimeout);
            return this;
        }

        public NewApplicationBuilder incomingSmsUrlCallbackTimeout(Long incomingSmsUrlCallbackTimeout) {
            this.params.put("incomingSmsUrlCallbackTimeout", incomingSmsUrlCallbackTimeout);
            return this;
        }

        public NewApplicationBuilder callbackHttpMethod(String callbackHttpMethod) {
            this.params.put("callbackHttpMethod", callbackHttpMethod);
            return this;
        }

        public Application create() throws IOException {
            return Applications.this.createApplication(this.params);
        }
    }

    public class QueryApplicationsBuilder {
        private Map<String, Object> params = new HashMap<String, Object>();

        public QueryApplicationsBuilder page(int page) {
            this.params.put("page", page);
            return this;
        }

        public QueryApplicationsBuilder size(int size) {
            this.params.put("size", size);
            return this;
        }

        public List<Application> list() throws IOException {
            return Applications.this.getApplications(this.params);
        }
    }
}

