/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthRestClient;
import com.bandwidth.sdk.model.AvailableNumber;
import com.bandwidth.sdk.model.BaseModelObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class AvailableNumbers
extends BaseModelObject {
    public AvailableNumbers(BandwidthRestClient client) {
        super(client, null, null);
    }

    public QueryLocalNumbersBuilder queryLocalNumbersBuilder() {
        return new QueryLocalNumbersBuilder();
    }

    public QueryTollFreeNumbersBuilder queryTollFreeNumbersBuilder() {
        return new QueryTollFreeNumbersBuilder();
    }

    private List<AvailableNumber> getLocalNumbers(Map<String, Object> params) throws IOException {
        String localUri = this.getLocalUri();
        JSONArray array = this.client.getArray(localUri, params);
        ArrayList<AvailableNumber> numbers = new ArrayList<AvailableNumber>();
        for (Object obj : array) {
            numbers.add(new AvailableNumber(this.client, localUri, (JSONObject)obj));
        }
        return numbers;
    }

    private String getLocalUri() {
        return StringUtils.join((Object[])new String[]{this.getUri(), "local"}, (char)'/');
    }

    private String getTollFreeUri() {
        return StringUtils.join((Object[])new String[]{this.getUri(), "tollFree"}, (char)'/');
    }

    @Override
    protected String getUri() {
        return StringUtils.join((Object[])new String[]{"availableNumbers"}, (char)'/');
    }

    private List<AvailableNumber> getTollFreeNumbers(Map<String, Object> params) throws IOException {
        String tollFreeUri = this.getTollFreeUri();
        JSONArray array = this.client.getArray(tollFreeUri, params);
        ArrayList<AvailableNumber> numbers = new ArrayList<AvailableNumber>();
        for (Object obj : array) {
            numbers.add(new AvailableNumber(this.client, tollFreeUri, (JSONObject)obj));
        }
        return numbers;
    }

    public class QueryLocalNumbersBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public List<AvailableNumber> list() throws IOException {
            return AvailableNumbers.this.getLocalNumbers(this.params);
        }

        public QueryLocalNumbersBuilder city(String city) {
            this.params.put("city", city);
            return this;
        }

        public QueryLocalNumbersBuilder state(String state) {
            this.params.put("state", state);
            return this;
        }

        public QueryLocalNumbersBuilder zip(String zip) {
            this.params.put("zip", zip);
            return this;
        }

        public QueryLocalNumbersBuilder areaCode(String areaCode) {
            this.params.put("areaCode", areaCode);
            return this;
        }

        public QueryLocalNumbersBuilder localNumber(String localNumber) {
            this.params.put("localNumber", localNumber);
            return this;
        }

        public QueryLocalNumbersBuilder inLocalCallingArea(boolean inLocalCallingArea) {
            this.params.put("inLocalCallingArea", String.valueOf(inLocalCallingArea));
            return this;
        }

        public QueryLocalNumbersBuilder quantity(int quantity) {
            this.params.put("quantity", String.valueOf(quantity));
            return this;
        }
    }

    public class QueryTollFreeNumbersBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public List<AvailableNumber> list() throws IOException {
            return AvailableNumbers.this.getTollFreeNumbers(this.params);
        }

        public QueryTollFreeNumbersBuilder quantity(int quantity) {
            this.params.put("quantity", String.valueOf(quantity));
            return this;
        }

        public QueryTollFreeNumbersBuilder pattern(String pattern) {
            this.params.put("pattern", pattern);
            return this;
        }
    }
}

