/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthRestClient;
import com.bandwidth.sdk.model.BaseModelObject;
import com.bandwidth.sdk.model.Call;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Calls
extends BaseModelObject {
    public Calls(BandwidthRestClient client, String parentUri) {
        super(client, parentUri, null);
    }

    public QueryCallsBuilder queryCallsBuilder() {
        return new QueryCallsBuilder();
    }

    public NewCallBuilder newCallBuilder() {
        return new NewCallBuilder();
    }

    public Call getCall(String callId) throws IOException {
        String callsUri = this.getUri();
        String eventPath = StringUtils.join((Object[])new String[]{callsUri, callId}, (char)'/');
        JSONObject jsonObject = this.client.getObject(eventPath);
        return new Call(this.client, callsUri, jsonObject);
    }

    @Override
    protected String getUri() {
        return StringUtils.join((Object[])new String[]{this.parentUri, "calls"}, (char)'/');
    }

    private List<Call> getCalls(Map<String, Object> params) throws IOException {
        String callsUri = this.getUri();
        JSONArray jsonArray = this.client.getArray(callsUri, params);
        ArrayList<Call> calls = new ArrayList<Call>();
        for (Object obj : jsonArray) {
            calls.add(new Call(this.client, callsUri, (JSONObject)obj));
        }
        return calls;
    }

    private Call newCall(Map<String, Object> params) throws IOException {
        String callsUri = this.getUri();
        JSONObject jsonObject = this.client.create(callsUri, params);
        return new Call(this.client, callsUri, jsonObject);
    }

    public class NewCallBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public NewCallBuilder callbackUrl(String callbackUrl) {
            this.params.put("callbackUrl", callbackUrl);
            return this;
        }

        public NewCallBuilder from(String from) {
            this.params.put("from", from);
            return this;
        }

        public NewCallBuilder to(String to) {
            this.params.put("to", to);
            return this;
        }

        public NewCallBuilder recordingEnabled(boolean recordingEnabled) {
            this.params.put("recordingEnabled", recordingEnabled);
            return this;
        }

        public NewCallBuilder bridgeId(String bridgeId) {
            this.params.put("bridgeId", bridgeId);
            return this;
        }

        public Call create() throws IOException {
            return Calls.this.newCall(this.params);
        }
    }

    public class QueryCallsBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public QueryCallsBuilder bridgeId(String bridgeId) {
            this.params.put("bridgeId", bridgeId);
            return this;
        }

        public QueryCallsBuilder conferenceId(String conferenceId) {
            this.params.put("conferenceId", conferenceId);
            return this;
        }

        public QueryCallsBuilder from(String from) {
            this.params.put("from", from);
            return this;
        }

        public QueryCallsBuilder to(String to) {
            this.params.put("to", to);
            return this;
        }

        public QueryCallsBuilder page(int page) {
            this.params.put("page", String.valueOf(page));
            return this;
        }

        public QueryCallsBuilder size(int size) {
            this.params.put("size", String.valueOf(size));
            return this;
        }

        public List<Call> list() throws IOException {
            return Calls.this.getCalls(this.params);
        }
    }
}

