/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthRestClient;
import com.bandwidth.sdk.model.BaseModelObject;
import com.bandwidth.sdk.model.PhoneNumber;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class PhoneNumbers
extends BaseModelObject {
    public PhoneNumbers(BandwidthRestClient client, String parentUri) {
        super(client, parentUri, null);
    }

    public QueryNumbersBuilder queryNumbersBuilder() {
        return new QueryNumbersBuilder();
    }

    public NewNumberBuilder newNumberBuilder() {
        return new NewNumberBuilder();
    }

    public PhoneNumber getNumber(String id) throws IOException {
        String numbersUri = this.getUri();
        String uri = StringUtils.join((Object[])new String[]{numbersUri, id}, (char)'/');
        JSONObject jsonObject = this.client.getObject(uri);
        return new PhoneNumber(this.client, numbersUri, jsonObject);
    }

    public PhoneNumber getNumberByNumber(String number) throws IOException {
        return this.getNumber(URLEncoder.encode(number, "UTF-8"));
    }

    @Override
    protected String getUri() {
        return StringUtils.join((Object[])new String[]{this.parentUri, "phoneNumbers"}, (char)'/');
    }

    private List<PhoneNumber> getNumbers(Map<String, Object> params) throws IOException {
        String uri = this.getUri();
        JSONArray jsonArray = this.client.getArray(uri, params);
        ArrayList<PhoneNumber> numbers = new ArrayList<PhoneNumber>();
        for (Object obj : jsonArray) {
            numbers.add(new PhoneNumber(this.client, uri, (JSONObject)obj));
        }
        return numbers;
    }

    private PhoneNumber newNumber(Map<String, Object> params) throws IOException {
        String uri = this.getUri();
        JSONObject jsonObject = this.client.create(uri, params);
        return new PhoneNumber(this.client, uri, jsonObject);
    }

    public class NewNumberBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public NewNumberBuilder number(String number) {
            this.params.put("number", number);
            return this;
        }

        public NewNumberBuilder applicationId(String applicationId) {
            this.params.put("applicationId", applicationId);
            return this;
        }

        public NewNumberBuilder name(String name) {
            this.params.put("name", name);
            return this;
        }

        public NewNumberBuilder fallbackNumber(String fallbackNumber) {
            this.params.put("fallbackNumber", fallbackNumber);
            return this;
        }

        public PhoneNumber create() throws IOException {
            return PhoneNumbers.this.newNumber(this.params);
        }
    }

    public class QueryNumbersBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public QueryNumbersBuilder page(int page) {
            this.params.put("page", page);
            return this;
        }

        public QueryNumbersBuilder size(int size) {
            this.params.put("size", size);
            return this;
        }

        public List<PhoneNumber> list() throws IOException {
            return PhoneNumbers.this.getNumbers(this.params);
        }
    }
}

