/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthRestClient;
import com.bandwidth.sdk.model.BaseModelObject;
import com.bandwidth.sdk.model.Recording;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Recordings
extends BaseModelObject {
    public Recordings(BandwidthRestClient client, String parentUri) {
        super(client, parentUri, null);
    }

    public QueryRecordingsBuilder queryRecordingsBuilder() {
        return new QueryRecordingsBuilder();
    }

    public Recording getRecording(String id) throws IOException {
        String recordingsUri = this.getUri();
        String uri = StringUtils.join((Object[])new String[]{recordingsUri, id}, (char)'/');
        JSONObject jsonObject = this.client.getObject(uri);
        return new Recording(this.client, recordingsUri, jsonObject);
    }

    private List<Recording> getRecordings(Map<String, Object> params) throws IOException {
        String uri = this.getUri();
        JSONArray array = this.client.getArray(uri, params);
        ArrayList<Recording> recordings = new ArrayList<Recording>();
        for (Object obj : array) {
            recordings.add(new Recording(this.client, uri, (JSONObject)obj));
        }
        return recordings;
    }

    @Override
    protected String getUri() {
        return StringUtils.join((Object[])new String[]{this.parentUri, "recordings"}, (char)'/');
    }

    public class QueryRecordingsBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public QueryRecordingsBuilder page(int page) {
            this.params.put("page", page);
            return this;
        }

        public QueryRecordingsBuilder size(int size) {
            this.params.put("size", size);
            return this;
        }

        public List<Recording> list() throws IOException {
            return Recordings.this.getRecordings(this.params);
        }
    }
}

