/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk;

import com.bandwidth.sdk.AppPlatformException;
import com.bandwidth.sdk.Client;
import com.bandwidth.sdk.RestResponse;
import com.bandwidth.sdk.exception.InvalidCredentialsException;
import com.bandwidth.sdk.exception.MissingCredentialsException;
import com.bandwidth.sdk.model.Account;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.BackoffManager;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.AIMDBackoffManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BandwidthClient
implements Client,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BandwidthClient.class);
    public static final int MONITOR_TIMER = 5000;
    protected String token;
    protected String secret;
    protected String apiVersion;
    protected String apiEndpoint;
    protected String usersUri;
    protected Integer maxTotal;
    protected Integer defaultMaxPerRoute;
    protected HttpClient httpClient;
    protected static BandwidthClient INSTANCE;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private IdleConnectionMonitorRunnable idleConnectionMonitorRunnable;

    public static synchronized BandwidthClient getInstance() {
        if (INSTANCE == null) {
            String userId = System.getProperty("com.bandwidth.userId");
            String apiToken = System.getProperty("com.bandwidth.apiToken");
            String apiSecret = System.getProperty("com.bandwidth.apiSecret");
            String apiEndpoint = System.getProperty("com.bandwidth.apiEndpoint");
            String apiVersion = System.getProperty("com.bandwidth.apiVersion");
            String maxTotal = System.getProperty("com.bandwidth.http.maxtotalconnections");
            String defaultMaxPerRoute = System.getProperty("com.bandwidth.http.maxdefaultconnectionsperroute");
            if (userId == null || apiToken == null || apiSecret == null || apiEndpoint == null || apiVersion == null) {
                userId = System.getenv().get("BANDWIDTH_USER_ID");
                apiToken = System.getenv().get("BANDWIDTH_API_TOKEN");
                apiSecret = System.getenv().get("BANDWIDTH_API_SECRET");
                apiEndpoint = System.getenv().get("BANDWIDTH_API_ENDPOINT");
                apiVersion = System.getenv().get("BANDWIDTH_API_VERSION");
            }
            if (maxTotal == null) {
                maxTotal = System.getenv().get("BANDWIDTH_MAX_TOTAL_CONNECTIONS");
            }
            Integer maxTotalNum = null;
            if (maxTotal != null) {
                try {
                    maxTotalNum = Integer.parseInt(maxTotal);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException(String.format("Invalid parameter for MAX_TOTAL_CONNECTIONS %s", maxTotal), ex);
                }
            }
            if (defaultMaxPerRoute == null) {
                defaultMaxPerRoute = System.getenv().get("BANDWIDTH_MAX_DEFAULT_CONNECTIONS_PER_ROUTE");
            }
            Integer defaultMaxPerRouteNum = null;
            if (defaultMaxPerRoute != null) {
                try {
                    defaultMaxPerRouteNum = Integer.parseInt(defaultMaxPerRoute);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException(String.format("Invalid parameter for MAX_DEFAULT_CONNECTIONS_PER_ROUTE %s", defaultMaxPerRoute), ex);
                }
            }
            INSTANCE = new BandwidthClient(userId, apiToken, apiSecret, apiEndpoint, apiVersion, maxTotalNum, defaultMaxPerRouteNum);
            if (userId != null || apiToken != null || apiSecret != null) {
                BandwidthClient.validateCredentials();
            }
        }
        return INSTANCE;
    }

    public static synchronized void shutdown() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    protected BandwidthClient(String userId, String apiToken, String apiSecret, String apiEndpoint, String apiVersion, Integer maxTotal, Integer defaultMaxPerRoute) {
        this.usersUri = String.format("users/%s", userId);
        this.token = apiToken;
        this.secret = apiSecret;
        this.apiEndpoint = apiEndpoint;
        this.apiVersion = apiVersion;
        if (apiEndpoint == null || apiVersion == null) {
            this.apiEndpoint = "https://api.catapult.inetwork.com";
            this.apiVersion = "v1";
        }
        this.maxTotal = maxTotal;
        if (maxTotal == null) {
            this.maxTotal = 200;
        }
        this.defaultMaxPerRoute = defaultMaxPerRoute;
        if (defaultMaxPerRoute == null) {
            this.defaultMaxPerRoute = 20;
        }
        this.httpClient = this.createHttpClient();
    }

    public void setCredentials(String userId, String apiToken, String apiSecret) {
        if (userId == null || apiToken == null || apiSecret == null) {
            throw new MissingCredentialsException();
        }
        this.usersUri = String.format("users/%s", userId.replaceAll(" ", ""));
        this.token = apiToken.replaceAll(" ", "");
        this.secret = apiSecret.replaceAll(" ", "");
        BandwidthClient.validateCredentials();
    }

    private static void validateCredentials() {
        try {
            Account.get().getAccountInfo();
        }
        catch (Exception e) {
            if (e instanceof AppPlatformException) {
                AppPlatformException appEx = (AppPlatformException)e;
                if (appEx.getStatus() == 401) {
                    throw new InvalidCredentialsException();
                }
            }
            throw new RuntimeException(e);
        }
    }

    public void setEndpointandVersion(String apiEndpoint, String apiVersion) {
        this.apiEndpoint = apiEndpoint;
        this.apiVersion = apiVersion;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    public String getUserResourceUri(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        return StringUtils.join((Object[])new String[]{this.getUserUri(), path}, (String)"/");
    }

    public String getUserResourceInstanceUri(String path, String instanceId) {
        if (StringUtils.isEmpty((CharSequence)path) || StringUtils.isEmpty((CharSequence)instanceId)) {
            throw new IllegalArgumentException("Path and Instance Id cannot be null");
        }
        return this.getUserResourceUri(path) + "/" + instanceId;
    }

    public String getBaseResourceUri(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        return path + "/";
    }

    public String getPath(String uri) {
        Object[] parts = new String[]{this.apiEndpoint, this.apiVersion, null};
        String base = StringUtils.join((Object[])parts, (String)"/");
        if (!uri.contains(base)) {
            parts[2] = uri;
            return StringUtils.join((Object[])parts, (String)"/");
        }
        return uri;
    }

    public String getUserUri() {
        return this.usersUri;
    }

    public RestResponse post(String uri, Map<String, Object> params) throws IOException, AppPlatformException {
        return this.request(this.getPath(uri), "POST", params);
    }

    public RestResponse postJson(String uri, String params) throws IOException, AppPlatformException {
        return this.requestJson(this.getPath(uri), "POST", params);
    }

    @Override
    public RestResponse get(String uri, Map<String, Object> params) throws Exception {
        String path = this.getPath(uri);
        RestResponse response = this.request(path, "GET", params);
        if (response.isError()) {
            throw new IOException(response.getResponseText());
        }
        return response;
    }

    public RestResponse put(String uri, Map<String, Object> params) throws IOException, AppPlatformException {
        return this.request(this.getPath(uri), "PUT", params);
    }

    public RestResponse delete(String uri) throws IOException, AppPlatformException {
        return this.request(this.getPath(uri), "DELETE");
    }

    public void upload(String uri, File sourceFile, String contentType) throws IOException, AppPlatformException {
        String path = this.getPath(uri);
        HttpPut request = (HttpPut)this.setupRequest(path, "PUT", null);
        request.setEntity((HttpEntity)(contentType == null ? new FileEntity(sourceFile) : new FileEntity(sourceFile, ContentType.parse((String)contentType))));
        this.performRequest((HttpUriRequest)request);
    }

    public void download(String uri, File destFile) throws IOException {
        String path = this.getPath(uri);
        HttpGet request = (HttpGet)this.setupRequest(path, "GET", Collections.<String, Object>emptyMap());
        OutputStream outputStream = null;
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            if (statusCode >= 400) {
                throw new IOException(EntityUtils.toString((HttpEntity)entity));
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(destFile));
            entity.writeTo(outputStream);
        }
        catch (ClientProtocolException e1) {
            throw new IOException(e1);
        }
        catch (IOException e1) {
            throw new IOException(e1);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected RestResponse request(String path, String method) throws IOException, AppPlatformException {
        return this.request(path, method, null);
    }

    protected RestResponse request(String path, String method, Map<String, Object> paramList) throws IOException, AppPlatformException {
        if (paramList == null) {
            paramList = Collections.emptyMap();
        }
        HttpUriRequest request = this.setupRequest(path, method, paramList);
        return this.performRequest(request);
    }

    protected RestResponse requestJson(String path, String method, String param) throws IOException, AppPlatformException {
        HttpUriRequest request = this.setupRequestJson(path, method, param);
        return this.performRequest(request);
    }

    protected RestResponse performRequest(HttpUriRequest request) throws IOException, AppPlatformException {
        if (this.usersUri == null || this.usersUri.isEmpty() || this.token == null || this.token.isEmpty() || this.secret == null || this.secret.isEmpty()) {
            throw new MissingCredentialsException();
        }
        RestResponse restResponse = RestResponse.createRestResponse(this.httpClient.execute(request));
        if (restResponse.getStatus() >= 400) {
            throw new AppPlatformException(restResponse.getResponseText(), restResponse.getStatus());
        }
        return restResponse;
    }

    protected HttpUriRequest setupRequest(String path, String method, Map<String, Object> params) {
        HttpUriRequest request = this.buildMethod(method, path, params);
        request.addHeader((Header)new BasicHeader("Accept", "application/json"));
        request.addHeader((Header)new BasicHeader("Accept-Charset", "utf-8"));
        request.setHeader((Header)new BasicHeader("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])(this.token + ":" + this.secret).getBytes()))));
        return request;
    }

    protected HttpUriRequest setupRequestJson(String path, String method, String params) {
        HttpUriRequest request = this.buildMethod(method, path, params);
        request.addHeader((Header)new BasicHeader("Accept", "application/json"));
        request.addHeader((Header)new BasicHeader("Accept-Charset", "utf-8"));
        request.setHeader((Header)new BasicHeader("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])(this.token + ":" + this.secret).getBytes()))));
        return request;
    }

    protected HttpUriRequest buildMethod(String method, String path, Map<String, Object> params) {
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"GET")) {
            return this.generateGetRequest(path, params);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"POST")) {
            return this.generatePostRequest(path, params);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"PUT")) {
            return this.generatePutRequest(path, params);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"DELETE")) {
            return this.generateDeleteRequest(path);
        }
        throw new RuntimeException("Must not be here.");
    }

    protected HttpUriRequest buildMethod(String method, String path, String params) {
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"POST")) {
            return this.generatePostRequest(path, params);
        }
        throw new RuntimeException(String.format("Method %s not supported.", method));
    }

    protected HttpGet generateGetRequest(String path, Map<String, Object> paramMap) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (String key : paramMap.keySet()) {
            pairs.add((NameValuePair)new BasicNameValuePair(key, paramMap.get(key).toString()));
        }
        URI uri = this.buildUri(path, pairs);
        return new HttpGet(uri);
    }

    protected HttpPost generatePostRequest(String path, Map<String, Object> paramMap) {
        HttpPost post = new HttpPost(this.buildUri(path));
        post.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString(paramMap), ContentType.APPLICATION_JSON));
        return post;
    }

    protected HttpPost generatePostRequest(String path, String param) {
        HttpPost post = new HttpPost(this.buildUri(path));
        post.setEntity((HttpEntity)new StringEntity(param, ContentType.APPLICATION_JSON));
        return post;
    }

    protected HttpPut generatePutRequest(String path, Map<String, Object> paramMap) {
        HttpPut put = new HttpPut(this.buildUri(path));
        if (paramMap != null) {
            put.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString(paramMap), ContentType.APPLICATION_JSON));
        }
        return put;
    }

    protected HttpDelete generateDeleteRequest(String path) {
        return new HttpDelete(this.buildUri(path));
    }

    protected URI buildUri(String path) {
        return this.buildUri(path, null);
    }

    protected URI buildUri(String path, List<NameValuePair> queryStringParams) {
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        if (queryStringParams != null && queryStringParams.size() > 0) {
            sb.append("?").append(URLEncodedUtils.format(queryStringParams, (String)"UTF-8"));
        }
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid uri", e);
        }
    }

    private HttpClient createHttpClient() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(this.maxTotal.intValue());
        cm.setDefaultMaxPerRoute(this.defaultMaxPerRoute.intValue());
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setKeepAliveStrategy(this.getStrategy()).setBackoffManager((BackoffManager)new AIMDBackoffManager((ConnPoolControl)cm)).build();
        this.idleConnectionMonitorRunnable = new IdleConnectionMonitorRunnable((HttpClientConnectionManager)cm);
        this.executorService.execute(this.idleConnectionMonitorRunnable);
        return httpClient;
    }

    private ConnectionKeepAliveStrategy getStrategy() {
        return new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    return Long.parseLong(value) * 1000L;
                }
                return 5000L;
            }
        };
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        if (!this.idleConnectionMonitorRunnable.shutdown) {
            this.idleConnectionMonitorRunnable.shutdown();
        }
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }

    public static class IdleConnectionMonitorRunnable
    implements Runnable {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorRunnable(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorRunnable idleConnectionMonitorRunnable = this;
                    synchronized (idleConnectionMonitorRunnable) {
                        this.wait(5000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException ex) {
                LOG.error("IdleConnectionMonitorRunnable failed.", (Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorRunnable idleConnectionMonitorRunnable = this;
            synchronized (idleConnectionMonitorRunnable) {
                this.notifyAll();
            }
        }
    }
}

