/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.AppPlatformException;
import com.bandwidth.sdk.BandwidthClient;
import com.bandwidth.sdk.RestResponse;
import com.bandwidth.sdk.model.Call;
import com.bandwidth.sdk.model.Gender;
import com.bandwidth.sdk.model.ResourceBase;
import com.bandwidth.sdk.model.ResourceList;
import com.bandwidth.sdk.model.SentenceLocale;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Bridge
extends ResourceBase {
    public static Bridge get(String id) throws Exception {
        BandwidthClient client = BandwidthClient.getInstance();
        return Bridge.get(client, id);
    }

    public static Bridge get(BandwidthClient client, String id) throws Exception {
        assert (client != null);
        String bridgesUri = client.getUserResourceInstanceUri("bridges", id);
        JSONObject jsonObject = Bridge.toJSONObject(client.get(bridgesUri, null));
        return new Bridge(client, jsonObject);
    }

    public static Bridge create(String id) throws Exception {
        return Bridge.create(id, null);
    }

    public static Bridge create(Call call1, Call call2) throws Exception {
        assert (call1 != null);
        String callId1 = call1.getId();
        String callId2 = call2.getId();
        return Bridge.create(callId1, callId2);
    }

    public static Bridge create(String callId1, String callId2) throws Exception {
        assert (callId1 != null);
        BandwidthClient client = BandwidthClient.getInstance();
        return Bridge.create(client, callId1, callId2);
    }

    public static Bridge create(BandwidthClient client, String callId1, String callId2) throws Exception {
        assert (callId1 != null);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bridgeAudio", "true");
        String[] callIds = null;
        if (callId1 != null && callId2 != null) {
            callIds = new String[]{callId1, callId2};
        } else if (callId1 != null && callId2 == null) {
            callIds = new String[]{callId1};
        } else if (callId1 == null && callId2 != null) {
            callIds = new String[]{callId2};
        }
        params.put("callIds", callIds == null ? Collections.emptyList() : Arrays.asList(callIds));
        return Bridge.create(client, params);
    }

    public static Bridge create(BandwidthClient client, Map<String, Object> params) throws Exception {
        assert (client != null && params != null);
        String bridgesUri = client.getUserResourceUri("bridges");
        RestResponse response = client.post(bridgesUri, params);
        JSONObject callObj = Bridge.toJSONObject(client.get(response.getLocation(), null));
        Bridge bridge = new Bridge(client, callObj);
        return bridge;
    }

    public static ResourceList<Bridge> list() throws IOException {
        return Bridge.list(0, 25);
    }

    public static ResourceList<Bridge> list(int page, int size) throws IOException {
        return Bridge.list(BandwidthClient.getInstance(), page, size);
    }

    public static ResourceList<Bridge> list(BandwidthClient client, int page, int size) throws IOException {
        String resourceUri = client.getUserResourceUri("bridges");
        ResourceList<Bridge> bridges = new ResourceList<Bridge>(page, size, resourceUri, Bridge.class);
        bridges.setClient(client);
        bridges.initialize();
        return bridges;
    }

    public Bridge(BandwidthClient client, JSONObject jsonObject) {
        super(client, jsonObject);
    }

    @Override
    protected void setUp(JSONObject jsonObject) {
        this.id = (String)jsonObject.get((Object)"id");
        this.updateProperties(jsonObject);
    }

    protected String getUri() {
        return this.client.getUserResourceInstanceUri("bridges", this.getId());
    }

    public List<Call> getBridgeCalls() throws Exception {
        String callsPath = StringUtils.join((Object[])new String[]{this.getUri(), "calls"}, (char)'/');
        JSONArray jsonArray = Bridge.toJSONArray(this.client.get(callsPath, null));
        ArrayList<Call> callList = new ArrayList<Call>();
        for (Object obj : jsonArray) {
            callList.add(new Call(this.client, (JSONObject)obj));
        }
        return callList;
    }

    public void setCallIds(String[] callIds) {
        this.putProperty("callIds", Arrays.asList(callIds));
    }

    public void setBridgeAudio(boolean bridgeAudio) {
        this.putProperty("bridgeAudio", bridgeAudio);
    }

    public void commit() throws IOException, AppPlatformException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bridgeAudio", this.isBridgeAudio());
        String[] callIds = this.getCallIds();
        params.put("callIds", callIds == null ? Collections.emptyList() : Arrays.asList(callIds));
        this.client.post(this.getUri(), params);
    }

    public String getState() {
        return this.getPropertyAsString("state");
    }

    public String[] getCallIds() {
        return this.getPropertyAsStringArray("callIds");
    }

    public String getCalls() {
        return this.getPropertyAsString("calls");
    }

    public boolean isBridgeAudio() {
        return this.getPropertyAsBoolean("bridgeAudio");
    }

    public Date getCompletedTime() {
        return this.getPropertyAsDate("completedTime");
    }

    public Date getCreatedTime() {
        return this.getPropertyAsDate("createdTime");
    }

    public Date getActivatedTime() {
        return this.getPropertyAsDate("activatedTime");
    }

    public NewBridgeAudioBuilder newBridgeAudioBuilder() {
        return new NewBridgeAudioBuilder();
    }

    public void stopAudioFilePlaying() throws IOException, AppPlatformException {
        new NewBridgeAudioBuilder().fileUrl("").create();
    }

    public void stopSentence() throws IOException, AppPlatformException {
        new NewBridgeAudioBuilder().sentence("").create();
    }

    private void createAudio(Map<String, Object> params) throws IOException, AppPlatformException {
        String audioPath = StringUtils.join((Object[])new String[]{this.getUri(), "audio"}, (char)'/');
        this.client.post(audioPath, params);
    }

    public String toString() {
        return "Bridge{id='" + this.getId() + '\'' + ", state=" + this.getState() + ", callIds=" + Arrays.toString(this.getCallIds()) + ", calls='" + this.getCalls() + '\'' + ", bridgeAudio=" + this.isBridgeAudio() + ", completedTime=" + this.getCompletedTime() + ", createdTime=" + this.getCreatedTime() + ", activatedTime=" + this.getActivatedTime() + '}';
    }

    public class NewBridgeAudioBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public NewBridgeAudioBuilder fileUrl(String fileUrl) {
            this.params.put("fileUrl", fileUrl);
            return this;
        }

        public NewBridgeAudioBuilder sentence(String sentence) {
            this.params.put("sentence", sentence);
            return this;
        }

        public NewBridgeAudioBuilder gender(Gender gender) {
            this.params.put("gender", gender.name());
            return this;
        }

        public NewBridgeAudioBuilder locale(SentenceLocale locale) {
            this.params.put("locale", locale.restValue);
            return this;
        }

        public NewBridgeAudioBuilder voice(String voice) {
            this.params.put("voice", voice);
            return this;
        }

        public NewBridgeAudioBuilder loopEnabled(boolean loopEnabled) {
            this.params.put("loopEnabled", String.valueOf(loopEnabled));
            return this;
        }

        public void create() throws IOException, AppPlatformException {
            Bridge.this.createAudio(this.params);
        }
    }
}

