/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.AppPlatformException;
import com.bandwidth.sdk.BandwidthClient;
import com.bandwidth.sdk.RestResponse;
import com.bandwidth.sdk.model.Gather;
import com.bandwidth.sdk.model.Gender;
import com.bandwidth.sdk.model.Recording;
import com.bandwidth.sdk.model.ResourceBase;
import com.bandwidth.sdk.model.ResourceList;
import com.bandwidth.sdk.model.SentenceLocale;
import com.bandwidth.sdk.model.events.EventBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Call
extends ResourceBase {
    public static Call get(String callId) throws Exception {
        BandwidthClient client = BandwidthClient.getInstance();
        return Call.get(client, callId);
    }

    public static Call get(BandwidthClient client, String callId) throws Exception {
        String callsUri = client.getUserResourceInstanceUri("calls", callId);
        JSONObject jsonObject = Call.toJSONObject(client.get(callsUri, null));
        return new Call(client, jsonObject);
    }

    public static ResourceList<Call> list() throws IOException {
        return Call.list(0, 25);
    }

    public static ResourceList<Call> list(int page, int size) throws IOException {
        return Call.list(BandwidthClient.getInstance(), page, size);
    }

    public static ResourceList<Call> list(BandwidthClient client, int page, int size) throws IOException {
        String callUri = client.getUserResourceUri("calls");
        ResourceList<Call> calls = new ResourceList<Call>(page, size, callUri, Call.class);
        calls.setClient(client);
        calls.initialize();
        return calls;
    }

    public static Call create(String to, String from) throws Exception {
        return Call.create(to, from, "none", null);
    }

    public static Call create(String to, String from, String callbackUrl, String tag) throws Exception {
        assert (to != null && from != null);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("to", to);
        params.put("from", from);
        params.put("callbackUrl", callbackUrl);
        params.put("tag", tag);
        Call call = Call.create(params);
        return call;
    }

    public static Call create(Map<String, Object> params) throws Exception {
        assert (params != null);
        return Call.create(BandwidthClient.getInstance(), params);
    }

    public static Call create(BandwidthClient client, Map<String, Object> params) throws Exception {
        assert (client != null && params != null);
        String callUri = client.getUserResourceUri("calls");
        RestResponse response = client.post(callUri, params);
        String callId = response.getLocation().substring(client.getPath(callUri).length() + 1);
        return Call.get(client, callId);
    }

    public Call(BandwidthClient client, JSONObject jsonObject) {
        super(client, jsonObject);
    }

    @Override
    protected void setUp(JSONObject jsonObject) {
        this.id = (String)jsonObject.get((Object)"id");
        this.updateProperties(jsonObject);
    }

    protected String getUri() {
        return this.client.getUserResourceInstanceUri("calls", this.getId());
    }

    public void speakSentence(Map<String, Object> params) throws IOException, AppPlatformException {
        assert (params != null);
        String audioUrl = this.getUri() + "/audio";
        this.client.post(audioUrl, params);
    }

    public void speakSentence(String sentence) throws IOException, AppPlatformException {
        this.speakSentence(sentence, null);
    }

    public void speakSentence(String sentence, String tag) throws IOException, AppPlatformException {
        JSONObject params = new JSONObject();
        params.put((Object)"sentence", (Object)sentence);
        params.put((Object)"voice", (Object)"kate");
        params.put((Object)"gender", (Object)"female");
        params.put((Object)"locale", (Object)"en_US");
        if (tag != null) {
            params.put((Object)"tag", (Object)tag);
        }
        this.speakSentence((Map<String, Object>)params);
    }

    public void playRecording(String recordingUrl) throws IOException, AppPlatformException {
        assert (recordingUrl != null);
        String audioUrl = this.getUri() + "/audio";
        JSONObject params = new JSONObject();
        params.put((Object)"fileUrl", (Object)recordingUrl);
        this.client.post(audioUrl, (Map<String, Object>)params);
    }

    public void playAudio(Map<String, Object> params) throws IOException, AppPlatformException {
        assert (params != null);
        String audioUrl = this.getUri() + "/audio";
        this.client.post(audioUrl, params);
    }

    public void createGather(String promptSentence) throws IOException, AppPlatformException {
        assert (promptSentence != null);
        String gatherUrl = this.getUri() + "/gather";
        JSONObject params = new JSONObject();
        params.put((Object)"tag", (Object)this.getId());
        params.put((Object)"maxDigits", (Object)"1");
        JSONObject prompt = new JSONObject();
        prompt.put((Object)"sentence", (Object)promptSentence);
        prompt.put((Object)"gender", (Object)"female");
        prompt.put((Object)"voice", (Object)"kate");
        prompt.put((Object)"locale", (Object)"en_US");
        prompt.put((Object)"bargeable", (Object)"true");
        params.put((Object)"prompt", (Object)prompt);
        this.client.post(gatherUrl, (Map<String, Object>)params);
    }

    public void createGather(Map<String, Object> gatherParams, Map<String, Object> promptParams) throws IOException, AppPlatformException {
        String gatherUrl = this.getUri() + "/gather";
        assert (gatherParams != null);
        if (promptParams != null && !promptParams.isEmpty()) {
            gatherParams.put("prompt", promptParams);
        }
        this.getClient().post(gatherUrl, gatherParams);
    }

    public String getDirection() {
        return this.getPropertyAsString("direction");
    }

    public String getState() {
        return this.getPropertyAsString("state");
    }

    public String getFrom() {
        return this.getPropertyAsString("from");
    }

    public String getTo() {
        return this.getPropertyAsString("to");
    }

    public String getCallbackUrl() {
        return this.getPropertyAsString("callbackUrl");
    }

    public String getEvents() {
        return this.getPropertyAsString("events");
    }

    public Date getStartTime() {
        return this.getPropertyAsDate("startTime");
    }

    public Date getActiveTime() {
        return this.getPropertyAsDate("activeTime");
    }

    public Date getEndTime() {
        return this.getPropertyAsDate("endTime");
    }

    public Long getChargeableDuration() {
        return this.getPropertyAsLong("chargeableDuration");
    }

    public boolean isRecordingEnabled() {
        return this.getPropertyAsBoolean("recordingEnabled");
    }

    public List<Recording> getRecordings() throws Exception {
        String recordingsPath = StringUtils.join((Object[])new String[]{this.getUri(), "recordings"}, (char)'/');
        JSONArray array = Call.toJSONArray(this.client.get(recordingsPath, null));
        ArrayList<Recording> list = new ArrayList<Recording>();
        for (Object object : array) {
            list.add(new Recording(this.client, recordingsPath, (JSONObject)object));
        }
        return list;
    }

    public List<EventBase> getEventsList() throws Exception {
        String eventsPath = StringUtils.join((Object[])new String[]{this.getUri(), "events"}, (char)'/');
        JSONArray array = Call.toJSONArray(this.client.get(eventsPath, null));
        ArrayList<EventBase> list = new ArrayList<EventBase>();
        for (Object object : array) {
            list.add(new EventBase((JSONObject)object));
        }
        return list;
    }

    public EventBase getEvent(String eventId) throws Exception {
        String eventPath = StringUtils.join((Object[])new String[]{this.getUri(), "events", eventId}, (char)'/');
        JSONObject jsonObject = Call.toJSONObject(this.client.get(eventPath, null));
        return new EventBase(jsonObject);
    }

    public void hangUp() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("state", "completed");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = Call.toJSONObject(this.client.get(uri, null));
        this.updateProperties(jsonObject);
    }

    public void answerOnIncoming() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("state", "active");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = Call.toJSONObject(this.client.get(uri, null));
        this.updateProperties(jsonObject);
    }

    public void rejectIncoming() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("state", "rejected");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = Call.toJSONObject(this.client.get(uri, null));
        this.updateProperties(jsonObject);
    }

    public void recordingOn() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("recordingEnabled", "true");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = Call.toJSONObject(this.client.get(uri, null));
        this.updateProperties(jsonObject);
    }

    public void recordingOff() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("recordingEnabled", "false");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = Call.toJSONObject(this.client.get(uri, null));
        this.updateProperties(jsonObject);
    }

    public CallTransferBuilder callTransferBuilder(String transferTo) {
        return new CallTransferBuilder(transferTo);
    }

    public CallAudioBuilder newAudioBuilder() {
        return new CallAudioBuilder();
    }

    public void stopAudioFilePlaying() throws IOException, AppPlatformException {
        new CallAudioBuilder().fileUrl("").create();
    }

    public void stopSentence() throws IOException, AppPlatformException {
        new CallAudioBuilder().sentence("").create();
    }

    public void sendDtmf(String dtmf) throws IOException, AppPlatformException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dtmfOut", dtmf);
        String uri = StringUtils.join((Object[])new String[]{this.getUri(), "dtmf"}, (char)'/');
        this.client.post(uri, params);
    }

    public CallGatherBuilder callGatherBuilder() {
        return new CallGatherBuilder();
    }

    public Gather getGather(String gatherId) throws Exception {
        String gatherPath = StringUtils.join((Object[])new String[]{this.getUri(), "gather", gatherId}, (char)'/');
        JSONObject jsonObject = Call.toJSONObject(this.client.get(gatherPath, null));
        return new Gather(this.client, jsonObject);
    }

    private void createGather(Map<String, Object> params) throws IOException, AppPlatformException {
        String uri = StringUtils.join((Object[])new String[]{this.getUri(), "gather"}, (char)'/');
        this.client.post(uri, params);
    }

    private void createCallAudio(Map<String, Object> params) throws IOException, AppPlatformException {
        String audioPath = StringUtils.join((Object[])new String[]{this.getUri(), "audio"}, (char)'/');
        this.client.post(audioPath, params);
    }

    private void transfer(Map<String, Object> params) throws Exception {
        params.put("state", "transferring");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = Call.toJSONObject(this.client.get(uri, null));
        this.updateProperties(jsonObject);
    }

    public String toString() {
        return "Call{id='" + this.getId() + '\'' + ", direction=" + this.getDirection() + ", state=" + this.getState() + ", from='" + this.getFrom() + '\'' + ", to='" + this.getTo() + '\'' + ", callbackUrl='" + this.getCallbackUrl() + '\'' + ", events='" + this.getEvents() + '\'' + ", startTime=" + this.getStartTime() + ", activeTime=" + this.getActiveTime() + ", endTime=" + this.getEndTime() + ", chargeableDuration=" + this.getChargeableDuration() + ", recordingEnabled=" + this.isRecordingEnabled() + '}';
    }

    public class CallGatherBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();
        private final Map<String, Object> prompt = new HashMap<String, Object>();

        public void create() throws IOException, AppPlatformException {
            if (!this.prompt.isEmpty()) {
                this.params.put("prompt", this.prompt);
            }
            Call.this.createGather(this.params);
        }

        public CallGatherBuilder maxDigits(int maxDigits) {
            this.params.put("maxDigits", String.valueOf(maxDigits));
            return this;
        }

        public CallGatherBuilder interDigitTimeout(int maxDigits) {
            this.params.put("interDigitTimeout", String.valueOf(maxDigits));
            return this;
        }

        public CallGatherBuilder terminatingDigits(String terminatingDigits) {
            this.params.put("terminatingDigits", terminatingDigits);
            return this;
        }

        public CallGatherBuilder suppressDtmf(boolean suppressDtmf) {
            this.params.put("suppressDtmf", String.valueOf(suppressDtmf));
            return this;
        }

        public CallGatherBuilder tag(String tag) {
            this.params.put("tag", tag);
            return this;
        }

        public CallGatherBuilder promptSentence(String promptSentence) {
            this.prompt.put("sentence", promptSentence);
            return this;
        }

        public CallGatherBuilder promptGender(Gender gender) {
            this.prompt.put("gender", gender.name());
            return this;
        }

        public CallGatherBuilder promptLocale(SentenceLocale locale) {
            this.prompt.put("locale", locale.restValue);
            return this;
        }

        public CallGatherBuilder promptFileUrl(String promptFileUrl) {
            this.prompt.put("fileUrl", promptFileUrl);
            return this;
        }

        public CallGatherBuilder promptLoopEnabled(boolean promptLoopEnabled) {
            this.prompt.put("loopEnabled", String.valueOf(promptLoopEnabled));
            return this;
        }

        public CallGatherBuilder promptBargeable(boolean promptBargeable) {
            this.prompt.put("bargeable", String.valueOf(promptBargeable));
            return this;
        }
    }

    public class CallAudioBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public CallAudioBuilder fileUrl(String fileUrl) {
            this.params.put("fileUrl", fileUrl);
            return this;
        }

        public CallAudioBuilder sentence(String sentence) {
            this.params.put("sentence", sentence);
            return this;
        }

        public CallAudioBuilder gender(Gender gender) {
            this.params.put("gender", gender.name());
            return this;
        }

        public CallAudioBuilder locale(SentenceLocale locale) {
            this.params.put("locale", locale.restValue);
            return this;
        }

        public CallAudioBuilder voice(String voice) {
            this.params.put("voice", voice);
            return this;
        }

        public CallAudioBuilder loopEnabled(boolean loopEnabled) {
            this.params.put("loopEnabled", String.valueOf(loopEnabled));
            return this;
        }

        public void create() throws IOException, AppPlatformException {
            Call.this.createCallAudio(this.params);
        }
    }

    public class CallTransferBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();
        private final Map<String, Object> whisperAudio = new HashMap<String, Object>();

        public CallTransferBuilder(String number) {
            this.params.put("transferTo", number);
        }

        public CallTransferBuilder callbackUrl(String callbackUrl) {
            this.params.put("callbackUrl", callbackUrl);
            return this;
        }

        public CallTransferBuilder transferCallerId(String transferCallerId) {
            this.params.put("transferCallerId", transferCallerId);
            return this;
        }

        public CallTransferBuilder sentence(String sentence) {
            this.whisperAudio.put("sentence", sentence);
            return this;
        }

        public CallTransferBuilder gender(Gender gender) {
            this.whisperAudio.put("gender", gender.name());
            return this;
        }

        public CallTransferBuilder voice(String voice) {
            this.whisperAudio.put("voice", voice);
            return this;
        }

        public CallTransferBuilder locale(SentenceLocale locale) {
            this.whisperAudio.put("locale", (Object)locale);
            return this;
        }

        public void create() throws Exception {
            if (!this.whisperAudio.isEmpty()) {
                this.params.put("whisperAudio", this.whisperAudio);
            }
            Call.this.transfer(this.params);
        }
    }
}

